/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IPBlock describes a particular CIDR (Ex. \"192.168.1.1/24\",\"2001:db9::/64\") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.")
@JsonPropertyOrder(value={"cidr", "except"})
public class IoK8sApiNetworkingV1IPBlock {
    public static final String JSON_PROPERTY_CIDR = "cidr";
    private String cidr;
    public static final String JSON_PROPERTY_EXCEPT = "except";
    private List<String> except = null;

    public IoK8sApiNetworkingV1IPBlock cidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    @ApiModelProperty(required=true, value="CIDR is a string representing the IP Block Valid examples are \"192.168.1.1/24\" or \"2001:db9::/64\"")
    @JsonProperty(value="cidr")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public IoK8sApiNetworkingV1IPBlock except(List<String> except) {
        this.except = except;
        return this;
    }

    public IoK8sApiNetworkingV1IPBlock addExceptItem(String exceptItem) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(exceptItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Except is a slice of CIDRs that should not be included within an IP Block Valid examples are \"192.168.1.1/24\" or \"2001:db9::/64\" Except values will be rejected if they are outside the CIDR range")
    @JsonProperty(value="except")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcept() {
        return this.except;
    }

    public void setExcept(List<String> except) {
        this.except = except;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiNetworkingV1IPBlock ioK8sApiNetworkingV1IPBlock = (IoK8sApiNetworkingV1IPBlock)o;
        return Objects.equals(this.cidr, ioK8sApiNetworkingV1IPBlock.cidr) && Objects.equals(this.except, ioK8sApiNetworkingV1IPBlock.except);
    }

    public int hashCode() {
        return Objects.hash(this.cidr, this.except);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiNetworkingV1IPBlock {\n");
        sb.append("    cidr: ").append(this.toIndentedString(this.cidr)).append("\n");
        sb.append("    except: ").append(this.toIndentedString(this.except)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

