/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiNetworkingV1NetworkPolicyEgressRule;
import net.stickycode.kuuty.model.v18.IoK8sApiNetworkingV1NetworkPolicyIngressRule;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1LabelSelector;

@ApiModel(description="NetworkPolicySpec provides the specification of a NetworkPolicy")
@JsonPropertyOrder(value={"egress", "ingress", "podSelector", "policyTypes"})
public class IoK8sApiNetworkingV1NetworkPolicySpec {
    public static final String JSON_PROPERTY_EGRESS = "egress";
    private List<IoK8sApiNetworkingV1NetworkPolicyEgressRule> egress = null;
    public static final String JSON_PROPERTY_INGRESS = "ingress";
    private List<IoK8sApiNetworkingV1NetworkPolicyIngressRule> ingress = null;
    public static final String JSON_PROPERTY_POD_SELECTOR = "podSelector";
    private IoK8sApimachineryPkgApisMetaV1LabelSelector podSelector;
    public static final String JSON_PROPERTY_POLICY_TYPES = "policyTypes";
    private List<String> policyTypes = null;

    public IoK8sApiNetworkingV1NetworkPolicySpec egress(List<IoK8sApiNetworkingV1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
        return this;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec addEgressItem(IoK8sApiNetworkingV1NetworkPolicyEgressRule egressItem) {
        if (this.egress == null) {
            this.egress = new ArrayList<IoK8sApiNetworkingV1NetworkPolicyEgressRule>();
        }
        this.egress.add(egressItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8")
    @JsonProperty(value="egress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiNetworkingV1NetworkPolicyEgressRule> getEgress() {
        return this.egress;
    }

    public void setEgress(List<IoK8sApiNetworkingV1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec ingress(List<IoK8sApiNetworkingV1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec addIngressItem(IoK8sApiNetworkingV1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<IoK8sApiNetworkingV1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)")
    @JsonProperty(value="ingress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiNetworkingV1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<IoK8sApiNetworkingV1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec podSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="podSelector")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApimachineryPkgApisMetaV1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec policyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    public IoK8sApiNetworkingV1NetworkPolicySpec addPolicyTypesItem(String policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of rule types that the NetworkPolicy relates to. Valid options are \"Ingress\", \"Egress\", or \"Ingress,Egress\". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ \"Egress\" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include \"Egress\" (since such a policy would not include an Egress section and would otherwise default to just [ \"Ingress\" ]). This field is beta-level in 1.8")
    @JsonProperty(value="policyTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiNetworkingV1NetworkPolicySpec ioK8sApiNetworkingV1NetworkPolicySpec = (IoK8sApiNetworkingV1NetworkPolicySpec)o;
        return Objects.equals(this.egress, ioK8sApiNetworkingV1NetworkPolicySpec.egress) && Objects.equals(this.ingress, ioK8sApiNetworkingV1NetworkPolicySpec.ingress) && Objects.equals(this.podSelector, ioK8sApiNetworkingV1NetworkPolicySpec.podSelector) && Objects.equals(this.policyTypes, ioK8sApiNetworkingV1NetworkPolicySpec.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiNetworkingV1NetworkPolicySpec {\n");
        sb.append("    egress: ").append(this.toIndentedString(this.egress)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("    policyTypes: ").append(this.toIndentedString(this.policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

