/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiNodeV1alpha1RuntimeClassSpec;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="RuntimeClass defines a class of container runtime supported in the cluster. The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md")
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec"})
public class IoK8sApiNodeV1alpha1RuntimeClass {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;
    public static final String JSON_PROPERTY_SPEC = "spec";
    private IoK8sApiNodeV1alpha1RuntimeClassSpec spec;

    public IoK8sApiNodeV1alpha1RuntimeClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiNodeV1alpha1RuntimeClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiNodeV1alpha1RuntimeClass metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public IoK8sApiNodeV1alpha1RuntimeClass spec(IoK8sApiNodeV1alpha1RuntimeClassSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="spec")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApiNodeV1alpha1RuntimeClassSpec getSpec() {
        return this.spec;
    }

    public void setSpec(IoK8sApiNodeV1alpha1RuntimeClassSpec spec) {
        this.spec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiNodeV1alpha1RuntimeClass ioK8sApiNodeV1alpha1RuntimeClass = (IoK8sApiNodeV1alpha1RuntimeClass)o;
        return Objects.equals(this.apiVersion, ioK8sApiNodeV1alpha1RuntimeClass.apiVersion) && Objects.equals(this.kind, ioK8sApiNodeV1alpha1RuntimeClass.kind) && Objects.equals(this.metadata, ioK8sApiNodeV1alpha1RuntimeClass.metadata) && Objects.equals(this.spec, ioK8sApiNodeV1alpha1RuntimeClass.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiNodeV1alpha1RuntimeClass {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

