/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.")
@JsonPropertyOrder(value={"currentHealthy", "desiredHealthy", "disruptedPods", "disruptionsAllowed", "expectedPods", "observedGeneration"})
public class IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus {
    public static final String JSON_PROPERTY_CURRENT_HEALTHY = "currentHealthy";
    private Integer currentHealthy;
    public static final String JSON_PROPERTY_DESIRED_HEALTHY = "desiredHealthy";
    private Integer desiredHealthy;
    public static final String JSON_PROPERTY_DISRUPTED_PODS = "disruptedPods";
    private Map<String, OffsetDateTime> disruptedPods = null;
    public static final String JSON_PROPERTY_DISRUPTIONS_ALLOWED = "disruptionsAllowed";
    private Integer disruptionsAllowed;
    public static final String JSON_PROPERTY_EXPECTED_PODS = "expectedPods";
    private Integer expectedPods;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus currentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return this;
    }

    @ApiModelProperty(required=true, value="current number of healthy pods")
    @JsonProperty(value="currentHealthy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    public void setCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus desiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return this;
    }

    @ApiModelProperty(required=true, value="minimum desired number of healthy pods")
    @JsonProperty(value="desiredHealthy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    public void setDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus disruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
        return this;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus putDisruptedPodsItem(String key, OffsetDateTime disruptedPodsItem) {
        if (this.disruptedPods == null) {
            this.disruptedPods = new HashMap<String, OffsetDateTime>();
        }
        this.disruptedPods.put(key, disruptedPodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.")
    @JsonProperty(value="disruptedPods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, OffsetDateTime> getDisruptedPods() {
        return this.disruptedPods;
    }

    public void setDisruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus disruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of pod disruptions that are currently allowed.")
    @JsonProperty(value="disruptionsAllowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public void setDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus expectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return this;
    }

    @ApiModelProperty(required=true, value="total number of pods counted by this disruption budget")
    @JsonProperty(value="expectedPods")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    public void setExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
    }

    public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus = (IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus)o;
        return Objects.equals(this.currentHealthy, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.currentHealthy) && Objects.equals(this.desiredHealthy, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.desiredHealthy) && Objects.equals(this.disruptedPods, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.disruptedPods) && Objects.equals(this.disruptionsAllowed, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.disruptionsAllowed) && Objects.equals(this.expectedPods, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.expectedPods) && Objects.equals(this.observedGeneration, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus {\n");
        sb.append("    currentHealthy: ").append(this.toIndentedString(this.currentHealthy)).append("\n");
        sb.append("    desiredHealthy: ").append(this.toIndentedString(this.desiredHealthy)).append("\n");
        sb.append("    disruptedPods: ").append(this.toIndentedString(this.disruptedPods)).append("\n");
        sb.append("    disruptionsAllowed: ").append(this.toIndentedString(this.disruptionsAllowed)).append("\n");
        sb.append("    expectedPods: ").append(this.toIndentedString(this.expectedPods)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

