/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.")
@JsonPropertyOrder(value={"allowedRuntimeClassNames", "defaultRuntimeClassName"})
public class IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions {
    public static final String JSON_PROPERTY_ALLOWED_RUNTIME_CLASS_NAMES = "allowedRuntimeClassNames";
    private List<String> allowedRuntimeClassNames = new ArrayList<String>();
    public static final String JSON_PROPERTY_DEFAULT_RUNTIME_CLASS_NAME = "defaultRuntimeClassName";
    private String defaultRuntimeClassName;

    public IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions allowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        this.allowedRuntimeClassNames = allowedRuntimeClassNames;
        return this;
    }

    public IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions addAllowedRuntimeClassNamesItem(String allowedRuntimeClassNamesItem) {
        this.allowedRuntimeClassNames.add(allowedRuntimeClassNamesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod. A value of \"*\" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.")
    @JsonProperty(value="allowedRuntimeClassNames")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames;
    }

    public void setAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        this.allowedRuntimeClassNames = allowedRuntimeClassNames;
    }

    public IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions defaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.")
    @JsonProperty(value="defaultRuntimeClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName;
    }

    public void setDefaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions ioK8sApiPolicyV1beta1RuntimeClassStrategyOptions = (IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions)o;
        return Objects.equals(this.allowedRuntimeClassNames, ioK8sApiPolicyV1beta1RuntimeClassStrategyOptions.allowedRuntimeClassNames) && Objects.equals(this.defaultRuntimeClassName, ioK8sApiPolicyV1beta1RuntimeClassStrategyOptions.defaultRuntimeClassName);
    }

    public int hashCode() {
        return Objects.hash(this.allowedRuntimeClassNames, this.defaultRuntimeClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiPolicyV1beta1RuntimeClassStrategyOptions {\n");
        sb.append("    allowedRuntimeClassNames: ").append(this.toIndentedString(this.allowedRuntimeClassNames)).append("\n");
        sb.append("    defaultRuntimeClassName: ").append(this.toIndentedString(this.defaultRuntimeClassName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

