/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.")
@JsonPropertyOrder(value={"apiGroups", "nonResourceURLs", "resourceNames", "resources", "verbs"})
public class IoK8sApiRbacV1PolicyRule {
    public static final String JSON_PROPERTY_API_GROUPS = "apiGroups";
    private List<String> apiGroups = null;
    public static final String JSON_PROPERTY_NON_RESOURCE_U_R_LS = "nonResourceURLs";
    private List<String> nonResourceURLs = null;
    public static final String JSON_PROPERTY_RESOURCE_NAMES = "resourceNames";
    private List<String> resourceNames = null;
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<String> resources = null;
    public static final String JSON_PROPERTY_VERBS = "verbs";
    private List<String> verbs = new ArrayList<String>();

    public IoK8sApiRbacV1PolicyRule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public IoK8sApiRbacV1PolicyRule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.")
    @JsonProperty(value="apiGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public IoK8sApiRbacV1PolicyRule nonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public IoK8sApiRbacV1PolicyRule addNonResourceURLsItem(String nonResourceURLsItem) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as \"pods\" or \"secrets\") or non-resource URL paths (such as \"/api\"),  but not both.")
    @JsonProperty(value="nonResourceURLs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public IoK8sApiRbacV1PolicyRule resourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public IoK8sApiRbacV1PolicyRule addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.")
    @JsonProperty(value="resourceNames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public IoK8sApiRbacV1PolicyRule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public IoK8sApiRbacV1PolicyRule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is a list of resources this rule applies to.  ResourceAll represents all resources.")
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public IoK8sApiRbacV1PolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public IoK8sApiRbacV1PolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.  VerbAll represents all kinds.")
    @JsonProperty(value="verbs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiRbacV1PolicyRule ioK8sApiRbacV1PolicyRule = (IoK8sApiRbacV1PolicyRule)o;
        return Objects.equals(this.apiGroups, ioK8sApiRbacV1PolicyRule.apiGroups) && Objects.equals(this.nonResourceURLs, ioK8sApiRbacV1PolicyRule.nonResourceURLs) && Objects.equals(this.resourceNames, ioK8sApiRbacV1PolicyRule.resourceNames) && Objects.equals(this.resources, ioK8sApiRbacV1PolicyRule.resources) && Objects.equals(this.verbs, ioK8sApiRbacV1PolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.nonResourceURLs, this.resourceNames, this.resources, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiRbacV1PolicyRule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    nonResourceURLs: ").append(this.toIndentedString(this.nonResourceURLs)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

