/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.")
@JsonPropertyOrder(value={"apiVersion", "kind", "name", "namespace"})
public class IoK8sApiRbacV1alpha1Subject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private String namespace;

    public IoK8sApiRbacV1alpha1Subject apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion holds the API group and version of the referenced subject. Defaults to \"v1\" for ServiceAccount subjects. Defaults to \"rbac.authorization.k8s.io/v1alpha1\" for User and Group subjects.")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiRbacV1alpha1Subject kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiRbacV1alpha1Subject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the object being referenced.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiRbacV1alpha1Subject namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiRbacV1alpha1Subject ioK8sApiRbacV1alpha1Subject = (IoK8sApiRbacV1alpha1Subject)o;
        return Objects.equals(this.apiVersion, ioK8sApiRbacV1alpha1Subject.apiVersion) && Objects.equals(this.kind, ioK8sApiRbacV1alpha1Subject.kind) && Objects.equals(this.name, ioK8sApiRbacV1alpha1Subject.name) && Objects.equals(this.namespace, ioK8sApiRbacV1alpha1Subject.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.namespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiRbacV1alpha1Subject {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

