/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1TopologySelectorTerm;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.")
@JsonPropertyOrder(value={"allowVolumeExpansion", "allowedTopologies", "apiVersion", "kind", "metadata", "mountOptions", "parameters", "provisioner", "reclaimPolicy", "volumeBindingMode"})
public class IoK8sApiStorageV1StorageClass {
    public static final String JSON_PROPERTY_ALLOW_VOLUME_EXPANSION = "allowVolumeExpansion";
    private Boolean allowVolumeExpansion;
    public static final String JSON_PROPERTY_ALLOWED_TOPOLOGIES = "allowedTopologies";
    private List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies = null;
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;
    public static final String JSON_PROPERTY_MOUNT_OPTIONS = "mountOptions";
    private List<String> mountOptions = null;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    private Map<String, String> parameters = null;
    public static final String JSON_PROPERTY_PROVISIONER = "provisioner";
    private String provisioner;
    public static final String JSON_PROPERTY_RECLAIM_POLICY = "reclaimPolicy";
    private String reclaimPolicy;
    public static final String JSON_PROPERTY_VOLUME_BINDING_MODE = "volumeBindingMode";
    private String volumeBindingMode;

    public IoK8sApiStorageV1StorageClass allowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllowVolumeExpansion shows whether the storage class allow volume expand")
    @JsonProperty(value="allowVolumeExpansion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public void setAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
    }

    public IoK8sApiStorageV1StorageClass allowedTopologies(List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
        return this;
    }

    public IoK8sApiStorageV1StorageClass addAllowedTopologiesItem(IoK8sApiCoreV1TopologySelectorTerm allowedTopologiesItem) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<IoK8sApiCoreV1TopologySelectorTerm>();
        }
        this.allowedTopologies.add(allowedTopologiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.")
    @JsonProperty(value="allowedTopologies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    public void setAllowedTopologies(List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
    }

    public IoK8sApiStorageV1StorageClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiStorageV1StorageClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiStorageV1StorageClass metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public IoK8sApiStorageV1StorageClass mountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public IoK8sApiStorageV1StorageClass addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. [\"ro\", \"soft\"]. Not validated - mount of the PVs will simply fail if one is invalid.")
    @JsonProperty(value="mountOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public IoK8sApiStorageV1StorageClass parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public IoK8sApiStorageV1StorageClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Parameters holds the parameters for the provisioner that should create volumes of this storage class.")
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public IoK8sApiStorageV1StorageClass provisioner(String provisioner) {
        this.provisioner = provisioner;
        return this;
    }

    @ApiModelProperty(required=true, value="Provisioner indicates the type of the provisioner.")
    @JsonProperty(value="provisioner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(String provisioner) {
        this.provisioner = provisioner;
    }

    public IoK8sApiStorageV1StorageClass reclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.")
    @JsonProperty(value="reclaimPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public IoK8sApiStorageV1StorageClass volumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.")
    @JsonProperty(value="volumeBindingMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public void setVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiStorageV1StorageClass ioK8sApiStorageV1StorageClass = (IoK8sApiStorageV1StorageClass)o;
        return Objects.equals(this.allowVolumeExpansion, ioK8sApiStorageV1StorageClass.allowVolumeExpansion) && Objects.equals(this.allowedTopologies, ioK8sApiStorageV1StorageClass.allowedTopologies) && Objects.equals(this.apiVersion, ioK8sApiStorageV1StorageClass.apiVersion) && Objects.equals(this.kind, ioK8sApiStorageV1StorageClass.kind) && Objects.equals(this.metadata, ioK8sApiStorageV1StorageClass.metadata) && Objects.equals(this.mountOptions, ioK8sApiStorageV1StorageClass.mountOptions) && Objects.equals(this.parameters, ioK8sApiStorageV1StorageClass.parameters) && Objects.equals(this.provisioner, ioK8sApiStorageV1StorageClass.provisioner) && Objects.equals(this.reclaimPolicy, ioK8sApiStorageV1StorageClass.reclaimPolicy) && Objects.equals(this.volumeBindingMode, ioK8sApiStorageV1StorageClass.volumeBindingMode);
    }

    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiStorageV1StorageClass {\n");
        sb.append("    allowVolumeExpansion: ").append(this.toIndentedString(this.allowVolumeExpansion)).append("\n");
        sb.append("    allowedTopologies: ").append(this.toIndentedString(this.allowedTopologies)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mountOptions: ").append(this.toIndentedString(this.mountOptions)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    provisioner: ").append(this.toIndentedString(this.provisioner)).append("\n");
        sb.append("    reclaimPolicy: ").append(this.toIndentedString(this.reclaimPolicy)).append("\n");
        sb.append("    volumeBindingMode: ").append(this.toIndentedString(this.volumeBindingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

