/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CSIDriverSpec is the specification of a CSIDriver.")
@JsonPropertyOrder(value={"attachRequired", "podInfoOnMount", "volumeLifecycleModes"})
public class IoK8sApiStorageV1beta1CSIDriverSpec {
    public static final String JSON_PROPERTY_ATTACH_REQUIRED = "attachRequired";
    private Boolean attachRequired;
    public static final String JSON_PROPERTY_POD_INFO_ON_MOUNT = "podInfoOnMount";
    private Boolean podInfoOnMount;
    public static final String JSON_PROPERTY_VOLUME_LIFECYCLE_MODES = "volumeLifecycleModes";
    private List<String> volumeLifecycleModes = null;

    public IoK8sApiStorageV1beta1CSIDriverSpec attachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.")
    @JsonProperty(value="attachRequired")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    public void setAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
    }

    public IoK8sApiStorageV1beta1CSIDriverSpec podInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. \"csi.storage.k8s.io/pod.name\": pod.Name \"csi.storage.k8s.io/pod.namespace\": pod.Namespace \"csi.storage.k8s.io/pod.uid\": string(pod.UID) \"csi.storage.k8s.io/ephemeral\": \"true\" iff the volume is an ephemeral inline volume                                 defined by a CSIVolumeSource, otherwise \"false\"  \"csi.storage.k8s.io/ephemeral\" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the \"Persistent\" and \"Ephemeral\" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.")
    @JsonProperty(value="podInfoOnMount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public void setPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
    }

    public IoK8sApiStorageV1beta1CSIDriverSpec volumeLifecycleModes(List<String> volumeLifecycleModes) {
        this.volumeLifecycleModes = volumeLifecycleModes;
        return this;
    }

    public IoK8sApiStorageV1beta1CSIDriverSpec addVolumeLifecycleModesItem(String volumeLifecycleModesItem) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(volumeLifecycleModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is \"Persistent\", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is \"Ephemeral\". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.")
    @JsonProperty(value="volumeLifecycleModes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public void setVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        this.volumeLifecycleModes = volumeLifecycleModes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiStorageV1beta1CSIDriverSpec ioK8sApiStorageV1beta1CSIDriverSpec = (IoK8sApiStorageV1beta1CSIDriverSpec)o;
        return Objects.equals(this.attachRequired, ioK8sApiStorageV1beta1CSIDriverSpec.attachRequired) && Objects.equals(this.podInfoOnMount, ioK8sApiStorageV1beta1CSIDriverSpec.podInfoOnMount) && Objects.equals(this.volumeLifecycleModes, ioK8sApiStorageV1beta1CSIDriverSpec.volumeLifecycleModes);
    }

    public int hashCode() {
        return Objects.hash(this.attachRequired, this.podInfoOnMount, this.volumeLifecycleModes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiStorageV1beta1CSIDriverSpec {\n");
        sb.append("    attachRequired: ").append(this.toIndentedString(this.attachRequired)).append("\n");
        sb.append("    podInfoOnMount: ").append(this.toIndentedString(this.podInfoOnMount)).append("\n");
        sb.append("    volumeLifecycleModes: ").append(this.toIndentedString(this.volumeLifecycleModes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

