/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.")
@JsonPropertyOrder(value={"apiVersion", "blockOwnerDeletion", "controller", "kind", "name", "uid"})
public class IoK8sApimachineryPkgApisMetaV1OwnerReference {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_BLOCK_OWNER_DELETION = "blockOwnerDeletion";
    private Boolean blockOwnerDeletion;
    public static final String JSON_PROPERTY_CONTROLLER = "controller";
    private Boolean controller;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_UID = "uid";
    private String uid;

    public IoK8sApimachineryPkgApisMetaV1OwnerReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="API version of the referent.")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApimachineryPkgApisMetaV1OwnerReference blockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs \"delete\" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.")
    @JsonProperty(value="blockOwnerDeletion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBlockOwnerDeletion() {
        return this.blockOwnerDeletion;
    }

    public void setBlockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
    }

    public IoK8sApimachineryPkgApisMetaV1OwnerReference controller(Boolean controller) {
        this.controller = controller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this reference points to the managing controller.")
    @JsonProperty(value="controller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getController() {
        return this.controller;
    }

    public void setController(Boolean controller) {
        this.controller = controller;
    }

    public IoK8sApimachineryPkgApisMetaV1OwnerReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApimachineryPkgApisMetaV1OwnerReference name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApimachineryPkgApisMetaV1OwnerReference uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids")
    @JsonProperty(value="uid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApimachineryPkgApisMetaV1OwnerReference ioK8sApimachineryPkgApisMetaV1OwnerReference = (IoK8sApimachineryPkgApisMetaV1OwnerReference)o;
        return Objects.equals(this.apiVersion, ioK8sApimachineryPkgApisMetaV1OwnerReference.apiVersion) && Objects.equals(this.blockOwnerDeletion, ioK8sApimachineryPkgApisMetaV1OwnerReference.blockOwnerDeletion) && Objects.equals(this.controller, ioK8sApimachineryPkgApisMetaV1OwnerReference.controller) && Objects.equals(this.kind, ioK8sApimachineryPkgApisMetaV1OwnerReference.kind) && Objects.equals(this.name, ioK8sApimachineryPkgApisMetaV1OwnerReference.name) && Objects.equals(this.uid, ioK8sApimachineryPkgApisMetaV1OwnerReference.uid);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.blockOwnerDeletion, this.controller, this.kind, this.name, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApimachineryPkgApisMetaV1OwnerReference {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    blockOwnerDeletion: ").append(this.toIndentedString(this.blockOwnerDeletion)).append("\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

