/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.exception.resolver;

import java.util.Iterator;
import net.stickycode.exception.resolver.Fragment;
import net.stickycode.exception.resolver.ParameterFragment;
import net.stickycode.exception.resolver.QuoteFragment;
import net.stickycode.exception.resolver.TextFragment;

public class FragmentIterator
implements Iterator<Fragment> {
    private String message;
    private int index;
    private int nextQuote;
    private int nextParameter;

    public FragmentIterator(String message) {
        this.message = message;
        this.nextParameter();
        this.nextQuote();
    }

    private void nextQuote() {
        this.nextQuote = this.message.indexOf("''", this.index);
    }

    private void nextParameter() {
        this.nextParameter = this.message.indexOf("{}", this.index);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.message.length();
    }

    @Override
    public Fragment next() {
        if (this.index == this.nextParameter) {
            this.updateIndex(this.nextParameter + 2);
            this.nextParameter();
            return new ParameterFragment();
        }
        if (this.index == this.nextQuote) {
            this.updateIndex(this.nextQuote + 2);
            this.nextQuote();
            return new QuoteFragment();
        }
        if (this.nextParameter == -1) {
            if (this.index < this.nextQuote) {
                return this.text(this.nextQuote);
            }
            return this.tail();
        }
        if (this.nextQuote == -1) {
            return this.text(this.nextParameter);
        }
        if (this.nextQuote < this.nextParameter) {
            return this.text(this.nextQuote);
        }
        return this.text(this.nextParameter);
    }

    private Fragment text(int nextIndex) {
        TextFragment textFragment = new TextFragment(this.message.substring(this.index, nextIndex));
        this.updateIndex(nextIndex);
        return textFragment;
    }

    private void updateIndex(int processed) {
        this.index = processed;
    }

    private Fragment tail() {
        TextFragment textFragment = new TextFragment(this.message.substring(this.index));
        this.index = this.message.length();
        return textFragment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

