/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.reflector;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.stickycode.reflector.FieldProcessor;
import net.stickycode.reflector.MethodProcessor;

public class Reflector {
    private List<FieldProcessor> fieldProcessors;
    private List<MethodProcessor> methodProcessors;

    public Reflector forEachField(FieldProcessor ... processors) {
        if (this.fieldProcessors == null) {
            this.fieldProcessors = Arrays.asList(processors);
        } else {
            for (FieldProcessor fieldProcessor : processors) {
                this.fieldProcessors.add(fieldProcessor);
            }
        }
        return this;
    }

    public Reflector forEachMethod(MethodProcessor ... processors) {
        if (this.methodProcessors == null) {
            this.methodProcessors = Arrays.asList(processors);
        } else {
            for (MethodProcessor methodProcessor : processors) {
                this.methodProcessors.add(methodProcessor);
            }
        }
        return this;
    }

    public void process(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (type != Object.class) {
            if (this.fieldProcessors != null) {
                this.processFields(null, type);
            }
            if (this.methodProcessors != null) {
                this.collectMethods(methods, null, type);
            }
            type = type.getSuperclass();
        }
        if (this.methodProcessors != null) {
            this.processMethods(methods, null);
        }
    }

    public void process(Object target) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> type = target.getClass(); type != Object.class; type = type.getSuperclass()) {
            if (this.fieldProcessors != null) {
                this.processFields(target, type);
            }
            if (this.methodProcessors == null) continue;
            this.collectMethods(methods, target, type);
        }
        if (this.methodProcessors != null) {
            this.processMethods(methods, target);
        }
    }

    private void processMethods(List<Method> methods, Object target) {
        for (MethodProcessor processor : this.methodProcessors) {
            processor.sort(methods);
        }
        for (MethodProcessor processor : this.methodProcessors) {
            for (Method method : methods) {
                processor.processMethod(target, method);
            }
        }
    }

    private void collectMethods(List<Method> methods, Object target, Class<?> type) {
        for (Method method : type.getDeclaredMethods()) {
            if (!this.canProcess(method)) continue;
            methods.add(method);
        }
    }

    private boolean canProcess(Method method) {
        for (MethodProcessor processor : this.methodProcessors) {
            if (!processor.canProcess(method)) continue;
            return true;
        }
        return false;
    }

    private void processFields(Object target, Class<?> type) {
        for (FieldProcessor processor : this.fieldProcessors) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                if (!processor.canProcess(field)) continue;
                processor.processField(target, field);
            }
        }
    }
}

