/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;
import net.straylightlabs.hola.dns.Domain;
import net.straylightlabs.hola.sd.Instance;
import net.straylightlabs.hola.sd.Query;
import net.straylightlabs.hola.sd.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolaDriver {
    static final Logger logger = LoggerFactory.getLogger(HolaDriver.class);

    public static void main(String[] args) {
        try {
            Service service = Service.fromName("_tivo-mindrpc._tcp");
            Query query = Query.createFor(service, Domain.LOCAL);
            Set<Instance> instances = query.runOnce();
            instances.stream().forEach(System.out::println);
            if (instances.size() == 0) {
                logger.error("No instances of type {} found :(", (Object)service);
            }
        }
        catch (UnknownHostException e) {
            logger.error("Unknown host: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO error: ", (Throwable)e);
        }
    }
}

