/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Record;

public class PtrRecord
extends Record {
    private final String userVisibleName;
    private final String ptrName;
    public static final String UNTITLED_NAME = "Untitled";

    public PtrRecord(ByteBuffer buffer, String name, Record.Class recordClass, long ttl, int rdLength) {
        super(name, recordClass, ttl);
        this.ptrName = rdLength > 0 ? PtrRecord.readNameFromBuffer(buffer) : "";
        this.userVisibleName = this.buildUserVisibleName();
    }

    public String getPtrName() {
        return this.ptrName;
    }

    public String getUserVisibleName() {
        return this.userVisibleName;
    }

    private String buildUserVisibleName() {
        String[] parts = this.ptrName.split("\\.");
        if (parts[0].length() > 0) {
            return parts[0];
        }
        return UNTITLED_NAME;
    }

    @Override
    public String toString() {
        return "PtrRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", ptrName='" + this.ptrName + '\'' + '}';
    }
}

