/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Domain;
import net.straylightlabs.hola.dns.Message;
import net.straylightlabs.hola.dns.Record;
import net.straylightlabs.hola.sd.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Question
extends Message {
    private final String qName;
    private final QType qType;
    private final QClass qClass;
    private static final Logger logger = LoggerFactory.getLogger(Question.class);
    private static final short UNICAST_RESPONSE_BIT = Short.MIN_VALUE;

    public static Question fromBuffer(ByteBuffer buffer) {
        String name = Record.readNameFromBuffer(buffer);
        QType type = QType.fromInt(buffer.getShort() & 0xFFFF);
        QClass qClass = QClass.fromInt(buffer.getShort() & 0xFFFF);
        return new Question(name, type, qClass);
    }

    public Question(String name, QType type, QClass qClass) {
        this.qName = name;
        this.qType = type;
        this.qClass = qClass;
        this.build();
    }

    public Question(Service service, Domain domain) {
        this.qName = service.getName() + "." + domain.getName();
        this.qType = QType.PTR;
        this.qClass = QClass.IN;
        this.build();
    }

    private void build() {
        this.buildHeader();
        for (String label : this.qName.split("\\.")) {
            this.addLabelToBuffer(label);
        }
        this.addLabelToBuffer("");
        this.buffer.putShort((short)this.qType.asUnsignedShort());
        this.buffer.putShort((short)this.qClass.asUnsignedShort());
    }

    private void addLabelToBuffer(String label) {
        byte[] labelBytes = label.getBytes();
        this.buffer.put((byte)(labelBytes.length & 0xFF));
        this.buffer.put(labelBytes);
    }

    private void buildHeader() {
        this.buffer.putShort((short)0);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        this.buffer.putShort((short)1);
        this.buffer.putShort((short)0);
        this.buffer.putInt(0);
    }

    public void askOn(MulticastSocket socket, InetAddress group) throws IOException {
        logger.debug("Asking question {}", (Object)this);
        try {
            this.askWithGroup(group, socket);
        }
        catch (UnknownHostException e) {
            System.err.println("UnknownHostException " + e);
        }
    }

    private void askWithGroup(InetAddress group, MulticastSocket socket) throws IOException {
        DatagramPacket packet = new DatagramPacket(this.buffer.array(), this.buffer.position(), group, 5353);
        packet.setAddress(group);
        socket.send(packet);
    }

    public boolean answeredBy(Record record) {
        return record.getName().equals(this.qName);
    }

    String getQName() {
        return this.qName;
    }

    QType getQType() {
        return this.qType;
    }

    QClass getQClass() {
        return this.qClass;
    }

    public String toString() {
        return "Question{qName=" + this.qName + ", qType=" + (Object)((Object)this.qType) + ", qClass=" + (Object)((Object)this.qClass) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Question question = (Question)o;
        return this.qName.equals(question.qName) && this.qType == question.qType && this.qClass == question.qClass;
    }

    public int hashCode() {
        int result = this.qName.hashCode();
        result = 31 * result + this.qType.hashCode();
        result = 31 * result + this.qClass.hashCode();
        return result;
    }

    public static enum QClass {
        IN(1),
        ANY(255);

        private final int value;

        public static QClass fromInt(int val) {
            for (QClass c : QClass.values()) {
                if (c.value != (val & Short.MAX_VALUE)) continue;
                return c;
            }
            throw new IllegalArgumentException("Can't convert " + val + " to a QClass");
        }

        private QClass(int value) {
            this.value = value;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }

    public static enum QType {
        A(1),
        NS(2),
        CNAME(5),
        SOA(6),
        MB(7),
        MG(8),
        MR(9),
        NULL(10),
        WKS(11),
        PTR(12),
        HINFO(13),
        MINFO(14),
        MX(15),
        TXT(16),
        AAAA(28),
        SRV(33),
        ANY(255);

        private final int value;

        public static QType fromInt(int val) {
            for (QType type : QType.values()) {
                if (type.value != val) continue;
                return type;
            }
            throw new IllegalArgumentException("Can't convert " + val + " to a QType");
        }

        private QType(int value) {
            this.value = value;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }
}

