/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.straylightlabs.hola.dns.ARecord;
import net.straylightlabs.hola.dns.AaaaRecord;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.SrvRecord;
import net.straylightlabs.hola.dns.TxtRecord;
import net.straylightlabs.hola.dns.UnknownRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Record {
    protected final String name;
    protected final long ttl;
    protected final Class recordClass;
    private static final Logger logger = LoggerFactory.getLogger(Record.class);
    public static final int USHORT_MASK = 65535;
    public static final long UINT_MASK = 0xFFFFFFFFL;
    public static final String NAME_CHARSET = "UTF-8";

    public static Record fromBuffer(ByteBuffer buffer) {
        String name = Record.readNameFromBuffer(buffer);
        Type type = Type.fromInt(buffer.getShort() & 0xFFFF);
        int tmp = buffer.getShort() & 0xFFFF;
        boolean flushCache = (tmp & 0x8000) == 32768;
        int rrClassByte = tmp & Short.MAX_VALUE;
        Class recordClass = Class.fromInt(rrClassByte);
        long ttl = (long)buffer.getInt() & 0xFFFFFFFFL;
        int rdLength = buffer.getShort() & 0xFFFF;
        switch (type) {
            case A: {
                try {
                    return new ARecord(buffer, name, recordClass, ttl);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Buffer does not represent a valid A record");
                }
            }
            case AAAA: {
                try {
                    return new AaaaRecord(buffer, name, recordClass, ttl);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Buffer does not represent a valid AAAA record");
                }
            }
            case PTR: {
                return new PtrRecord(buffer, name, recordClass, ttl, rdLength);
            }
            case SRV: {
                return new SrvRecord(buffer, name, recordClass, ttl);
            }
            case TXT: {
                return new TxtRecord(buffer, name, recordClass, ttl, rdLength);
            }
        }
        logger.debug("Buffer represents an unsupported record type, skipping ahead {} bytes", (Object)rdLength);
        return new UnknownRecord(buffer, name, recordClass, ttl, rdLength);
    }

    protected Record(String name, Class recordClass, long ttl) {
        this.name = name;
        this.recordClass = recordClass;
        this.ttl = ttl;
    }

    public static String readNameFromBuffer(ByteBuffer buffer) {
        int labelLength;
        ArrayList<String> labels = new ArrayList<String>();
        int continueFrom = -1;
        do {
            buffer.mark();
            labelLength = buffer.get() & 0xFF;
            if (Record.isPointer(labelLength)) {
                buffer.reset();
                int offset = buffer.getShort() & 0x3FFF;
                if (continueFrom < 0) {
                    continueFrom = buffer.position();
                }
                buffer.position(offset);
                continue;
            }
            String label = Record.readLabel(buffer, labelLength);
            labels.add(label);
        } while (labelLength != 0);
        if (continueFrom >= 0) {
            buffer.position(continueFrom);
        }
        return labels.stream().collect(Collectors.joining("."));
    }

    private static boolean isPointer(int octet) {
        return (octet & 0xC0) == 192;
    }

    private static String readLabel(ByteBuffer buffer, int length) {
        String label = "";
        if (length > 0) {
            byte[] labelBuffer = new byte[length];
            buffer.get(labelBuffer);
            try {
                label = new String(labelBuffer, NAME_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("UnsupportedEncoding: " + e);
            }
        }
        return label;
    }

    public static List<String> readStringsFromBuffer(ByteBuffer buffer, int length) {
        String label;
        ArrayList<String> strings = new ArrayList<String>();
        int bytesRead = 0;
        do {
            int stringLength = buffer.get() & 0xFF;
            label = Record.readLabel(buffer, stringLength);
            strings.add(label);
        } while ((bytesRead += label.length() + 1) < length);
        return strings;
    }

    public String getName() {
        return this.name;
    }

    public long getTTL() {
        return this.ttl;
    }

    public String toString() {
        return "Record{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + '}';
    }

    static enum Class {
        IN(1);

        private final int value;

        public static Class fromInt(int val) {
            for (Class c : Class.values()) {
                if (c.value != val) continue;
                return c;
            }
            throw new IllegalArgumentException(String.format("Can't convert 0x%04x to a Class", val));
        }

        private Class(int value) {
            this.value = value;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }

    static enum Type {
        UNSUPPORTED(0),
        A(1),
        NS(2),
        CNAME(5),
        SOA(6),
        NULL(10),
        WKS(11),
        PTR(12),
        HINFO(13),
        MINFO(14),
        MX(15),
        TXT(16),
        AAAA(28),
        SRV(33);

        private final int value;

        public static Type fromInt(int val) {
            for (Type type : Type.values()) {
                if (type.value != val) continue;
                return type;
            }
            return UNSUPPORTED;
        }

        private Type(int value) {
            this.value = value;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }
}

