/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.straylightlabs.hola.dns.Message;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.Question;
import net.straylightlabs.hola.dns.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends Message {
    private final List<Question> questions = new ArrayList<Question>();
    private final List<Record> records = new ArrayList<Record>();
    private int numQuestions;
    private int numAnswers;
    private int numNameServers;
    private int numAdditionalRecords;
    private static final Logger logger = LoggerFactory.getLogger(Response.class);
    private static final int QR_MASK = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int RCODE_MASK = 15;

    public static Response createFrom(DatagramPacket packet) {
        Response response = new Response(packet);
        response.parseRecords();
        return response;
    }

    private Response() {
    }

    private Response(DatagramPacket packet) {
        this();
        byte[] dstBuffer = this.buffer.array();
        System.arraycopy(packet.getData(), packet.getOffset(), dstBuffer, 0, packet.getLength());
        this.buffer.limit(packet.getLength());
        this.buffer.position(0);
    }

    private void parseRecords() {
        Record record;
        int i;
        this.parseHeader();
        for (i = 0; i < this.numQuestions; ++i) {
            Question question = Question.fromBuffer(this.buffer);
            this.questions.add(question);
        }
        for (i = 0; i < this.numAnswers; ++i) {
            record = Record.fromBuffer(this.buffer);
            this.records.add(record);
        }
        for (i = 0; i < this.numNameServers; ++i) {
            record = Record.fromBuffer(this.buffer);
            this.records.add(record);
        }
        for (i = 0; i < this.numAdditionalRecords; ++i) {
            record = Record.fromBuffer(this.buffer);
            this.records.add(record);
        }
    }

    private void parseHeader() {
        this.readUnsignedShort();
        int codes = this.readUnsignedShort();
        if ((codes & 0x8000) != 32768) {
            throw new IllegalArgumentException("Packet is not a DNS response");
        }
        if ((codes & 0x7800) != 0) {
            throw new IllegalArgumentException("mDNS response packets can't have OPCODE values");
        }
        if ((codes & 0xF) != 0) {
            throw new IllegalArgumentException("mDNS response packets can't have RCODE values");
        }
        this.numQuestions = this.readUnsignedShort();
        this.numAnswers = this.readUnsignedShort();
        this.numNameServers = this.readUnsignedShort();
        this.numAdditionalRecords = this.readUnsignedShort();
        logger.debug("Questions={}, Answers={}, NameServers={}, AdditionalRecords={}", new Object[]{this.numQuestions, this.numAnswers, this.numNameServers, this.numAdditionalRecords});
    }

    public Set<Record> getRecords() {
        return new HashSet<Record>(Collections.unmodifiableSet(new HashSet<Record>(this.records)));
    }

    public String getUserVisibleName() {
        Optional<PtrRecord> record = this.records.stream().filter(r -> r instanceof PtrRecord).map(r -> (PtrRecord)r).findAny();
        if (record.isPresent()) {
            return record.get().getUserVisibleName();
        }
        logger.debug("No PTR records: {}", this.records);
        throw new IllegalStateException("Cannot call getUserVisibleName when no PTR record is available");
    }

    public boolean answers(Set<Question> questions) {
        return this.records.stream().filter(r -> {
            boolean match = false;
            String name = r.getName();
            for (Question q : questions) {
                if (!name.equals(q.getQName())) continue;
                match = true;
                break;
            }
            return match;
        }).count() > 0L;
    }

    public String toString() {
        return "Response{questions=" + this.questions + ", records=" + this.records + ", numQuestions=" + this.numQuestions + ", numAnswers=" + this.numAnswers + ", numNameServers=" + this.numNameServers + ", numAdditionalRecords=" + this.numAdditionalRecords + '}';
    }

    int getNumQuestions() {
        return this.numQuestions;
    }

    int getNumAnswers() {
        return this.numAnswers;
    }

    int getNumNameServers() {
        return this.numNameServers;
    }

    int getNumAdditionalRecords() {
        return this.numAdditionalRecords;
    }
}

