/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Record;

public class SrvRecord
extends Record {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;

    public SrvRecord(ByteBuffer buffer, String name, Record.Class recordClass, long ttl) {
        super(name, recordClass, ttl);
        this.priority = buffer.getShort() & 0xFFFF;
        this.weight = buffer.getShort() & 0xFFFF;
        this.port = buffer.getShort() & 0xFFFF;
        this.target = SrvRecord.readNameFromBuffer(buffer);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        return "SrvRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", priority=" + this.priority + ", weight=" + this.weight + ", port=" + this.port + ", target='" + this.target + '\'' + '}';
    }
}

