/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.straylightlabs.hola.dns.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtRecord
extends Record {
    private Map<String, String> attributes;
    private static final Logger logger = LoggerFactory.getLogger(TxtRecord.class);

    public TxtRecord(ByteBuffer buffer, String name, Record.Class recordClass, long ttl, int length) {
        super(name, recordClass, ttl);
        List<String> strings = TxtRecord.readStringsFromBuffer(buffer, length);
        this.attributes = this.parseDataStrings(strings);
    }

    private Map<String, String> parseDataStrings(List<String> strings) {
        HashMap<String, String> pairs = new HashMap<String, String>();
        strings.stream().forEach(s -> {
            String[] parts = s.split("=");
            if (parts.length > 1) {
                pairs.put(parts[0], parts[1]);
            }
        });
        return pairs;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public String toString() {
        return "TxtRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", attributes=" + this.attributes + '}';
    }
}

