/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.sd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.straylightlabs.hola.dns.ARecord;
import net.straylightlabs.hola.dns.AaaaRecord;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.Record;
import net.straylightlabs.hola.dns.SrvRecord;
import net.straylightlabs.hola.dns.TxtRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instance {
    private final String name;
    private final Set<InetAddress> addresses;
    private final int port;
    private final Map<String, String> attributes;
    private static final Logger logger = LoggerFactory.getLogger(Instance.class);

    static Instance createFromRecords(PtrRecord ptr, Set<Record> records) {
        String name = ptr.getUserVisibleName();
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Map<String, String> attributes = Collections.emptyMap();
        Optional<SrvRecord> srv = records.stream().filter(r -> r instanceof SrvRecord && r.getName().equals(ptr.getPtrName())).map(r -> (SrvRecord)r).findFirst();
        if (!srv.isPresent()) {
            throw new IllegalStateException("Cannot create Instance when no SRV record is available");
        }
        logger.debug("Using SrvRecord {} to create instance for {}", srv, (Object)ptr);
        int port = srv.get().getPort();
        addresses.addAll(records.stream().filter(r -> r instanceof ARecord).filter(r -> r.getName().equals(((SrvRecord)srv.get()).getTarget())).map(r -> ((ARecord)r).getAddress()).collect(Collectors.toList()));
        addresses.addAll(records.stream().filter(r -> r instanceof AaaaRecord).filter(r -> r.getName().equals(((SrvRecord)srv.get()).getTarget())).map(r -> ((AaaaRecord)r).getAddress()).collect(Collectors.toList()));
        Optional<TxtRecord> txt = records.stream().filter(r -> r instanceof TxtRecord && r.getName().equals(ptr.getPtrName())).map(r -> (TxtRecord)r).findFirst();
        if (txt.isPresent()) {
            logger.debug("Using TxtRecord {} to create attributes for {}", txt, (Object)ptr);
            attributes = txt.get().getAttributes();
        }
        return new Instance(name, addresses, port, attributes);
    }

    private Instance(String name, List<InetAddress> addresses, int port, Map<String, String> attributes) {
        this.name = name;
        this.addresses = new HashSet<InetAddress>();
        this.addresses.addAll(addresses);
        this.port = port;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public Set<InetAddress> getAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasAttribute(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    public String lookupAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public String toString() {
        return "Instance{name='" + this.name + '\'' + ", addresses=" + this.addresses + ", port=" + this.port + ", attributes=" + this.attributes + '}';
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.port;
        for (InetAddress inetAddress : this.addresses) {
            result = 31 * result + inetAddress.hashCode();
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            result = 31 * result + entry.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        for (InetAddress address : this.addresses) {
            if (other.addresses.contains(address)) continue;
            return false;
        }
        for (InetAddress address : other.addresses) {
            if (this.addresses.contains(address)) continue;
            return false;
        }
        for (String key : this.attributes.keySet()) {
            if (other.attributes.containsKey(key) && other.attributes.get(key).equals(this.attributes.get(key))) continue;
            return false;
        }
        for (String key : other.attributes.keySet()) {
            if (this.attributes.containsKey(key) && this.attributes.get(key).equals(other.attributes.get(key))) continue;
            return false;
        }
        return true;
    }
}

