/*
 * Decompiled with CFR 0.152.
 */
package net.surguy.queue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import net.surguy.queue.AmazonS3Store$;
import net.surguy.queue.Logging;
import net.surguy.queue.Logging$class;
import net.surguy.queue.Store;
import org.slf4j.Logger;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u0013\ti\u0011)\\1{_:\u001c6g\u0015;pe\u0016T!a\u0001\u0003\u0002\u000bE,X-^3\u000b\u0005\u00151\u0011AB:ve\u001e,\u0018PC\u0001\b\u0003\rqW\r^\u0002\u0001'\r\u0001!B\u0004\t\u0003\u00171i\u0011AA\u0005\u0003\u001b\t\u0011Qa\u0015;pe\u0016\u0004\"aC\b\n\u0005A\u0011!a\u0002'pO\u001eLgn\u001a\u0005\t%\u0001\u0011)\u0019!C\u0001'\u0005Q!-^2lKRt\u0015-\\3\u0016\u0003Q\u0001\"!F\u000e\u000f\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u00035]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\fEV\u001c7.\u001a;OC6,\u0007\u0005C\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0011\u0002\"a\u0003\u0001\t\u000bI\u0001\u0003\u0019\u0001\u000b\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511\r\\5f]R,\u0012\u0001\u000b\t\u0003SIj\u0011A\u000b\u0006\u0003W1\n!a]\u001a\u000b\u00055r\u0013\u0001C:feZL7-Z:\u000b\u0005=\u0002\u0014!C1nCj|g.Y<t\u0015\u0005\t\u0014aA2p[&\u00111G\u000b\u0002\u000f\u00036\f'p\u001c8Tg\rc\u0017.\u001a8u\u0011\u0019)\u0004\u0001)A\u0005Q\u000591\r\\5f]R\u0004\u0003\"B\u001c\u0001\t\u0003A\u0014\u0001\u00047jgR\u001cuN\u001c;f]R\u001cH#A\u001d\u0011\u0007izD#D\u0001<\u0015\taT(A\u0005j[6,H/\u00192mK*\u0011ahF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001!<\u0005\u0011a\u0015n\u001d;\t\u000b\t\u0003A\u0011A\"\u0002\u0015\u0005$G\rV8Ti>\u0014X\rF\u0002E\u000f&\u0003\"AF#\n\u0005\u0019;\"\u0001B+oSRDQ\u0001S!A\u0002Q\t!\"\u001b3f]RLg-[3s\u0011\u0015Q\u0015\t1\u0001L\u0003\u00111\u0017\u000e\\3\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015AA5p\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\t\u0019KG.\u001a\u0005\u0006)\u0002!\t!V\u0001\u0012e\u0016$(/[3wK\u001a\u0013x.\\*u_J,GC\u0001,]!\t9&,D\u0001Y\u0015\tI&&A\u0003n_\u0012,G.\u0003\u0002\\1\n\u00192kM(cU\u0016\u001cG/\u00138qkR\u001cFO]3b[\")\u0001j\u0015a\u0001)!)a\f\u0001C\u0001?\u0006A1\r\\3be\u0006cG\u000eF\u0001E\u0001")
public class AmazonS3Store
extends Store
implements Logging {
    private final String bucketName;
    private final AmazonS3Client client;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        AmazonS3Store amazonS3Store = this;
        synchronized (amazonS3Store) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public String bucketName() {
        return this.bucketName;
    }

    private AmazonS3Client client() {
        return this.client;
    }

    public List<String> listContents() {
        ListBuffer contents = new ListBuffer();
        ObjectListing objects = this.client().listObjects(new ListObjectsRequest().withBucketName(this.bucketName()));
        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)contents).addAll(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(objects.getObjectSummaries()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(S3ObjectSummary x$2) {
                return x$2.getKey();
            }
        }, Buffer$.MODULE$.canBuildFrom())));
        while (objects.isTruncated()) {
            objects = this.client().listNextBatchOfObjects(objects);
            JavaConversions$.MODULE$.bufferAsJavaList((Buffer)contents).addAll(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(objects.getObjectSummaries()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(S3ObjectSummary x$3) {
                    return x$3.getKey();
                }
            }, Buffer$.MODULE$.canBuildFrom())));
        }
        this.log().debug(new StringBuilder().append((Object)"Listing ").append((Object)BoxesRunTime.boxToInteger((int)contents.length())).append((Object)" items in bucket ").append((Object)this.bucketName()).toString());
        return contents.toList();
    }

    @Override
    public void addToStore(String identifier, File file) {
        this.log().debug(new StringBuilder().append((Object)"Uploading ").append((Object)identifier).append((Object)" to bucket ").append((Object)this.bucketName()).toString());
        this.client().putObject(new PutObjectRequest(this.bucketName(), identifier, file));
    }

    public S3ObjectInputStream retrieveFromStore(String identifier) {
        this.log().debug(new StringBuilder().append((Object)"Downloading ").append((Object)identifier).append((Object)" from bucket ").append((Object)this.bucketName()).toString());
        return this.client().getObject(new GetObjectRequest(this.bucketName(), identifier)).getObjectContent();
    }

    @Override
    public void clearAll() {
        this.log().debug(new StringBuilder().append((Object)"Deleting all objects from bucket ").append((Object)this.bucketName()).toString());
        this.client().deleteObjects(new DeleteObjectsRequest(this.bucketName()).withKeys((String[])this.listContents().toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    /*
     * WARNING - void declaration
     */
    public AmazonS3Store(String bucketName) {
        void var2_2;
        this.bucketName = bucketName;
        Logging$class.$init$(this);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        s3.setRegion(Region.getRegion((Regions)Regions.US_WEST_2));
        Object object = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(s3.listBuckets()).map((Function1)new $anonfun$1(this), Buffer$.MODULE$.canBuildFrom())).contains((Object)bucketName) ? BoxedUnit.UNIT : s3.createBucket(bucketName);
        this.log().debug(new StringBuilder().append((Object)"Starting Amazon S3 store with bucket ").append((Object)bucketName).toString());
        this.client = var2_2;
    }
}

