/*
 * Decompiled with CFR 0.152.
 */
package net.surguy.queue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.surguy.queue.Logging;
import net.surguy.queue.Logging$class;
import net.surguy.queue.MessageWrapper;
import net.surguy.queue.Queue;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u0013\tq\u0011)\\1{_:\u001c\u0016o])vKV,'BA\u0002\u0005\u0003\u0015\tX/Z;f\u0015\t)a!\u0001\u0004tkJ<W/\u001f\u0006\u0002\u000f\u0005\u0019a.\u001a;\u0004\u0001M\u0019\u0001A\u0003\r\u0011\u0007-aa\"D\u0001\u0003\u0013\ti!AA\u0003Rk\u0016,X\r\u0005\u0002\u0010+9\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\u00051\u0001K]3eK\u001aL!AF\f\u0003\rM#(/\u001b8h\u0015\t!\u0012\u0003\u0005\u0002\f3%\u0011!D\u0001\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0003i\u0012!C9vKV,g*Y7f+\u0005q\u0001\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0002\u0015E,X-^3OC6,\u0007\u0005C\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0011\u0002\"a\u0003\u0001\t\u000bq\u0001\u0003\u0019\u0001\b\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511\r\\5f]R,\u0012\u0001\u000b\t\u0003SIj\u0011A\u000b\u0006\u0003W1\n1a]9t\u0015\tic&\u0001\u0005tKJ4\u0018nY3t\u0015\ty\u0003'A\u0005b[\u0006TxN\\1xg*\t\u0011'A\u0002d_6L!a\r\u0016\u0003\u001f\u0005k\u0017M_8o'F\u001b6\t\\5f]RDa!\u000e\u0001!\u0002\u0013A\u0013aB2mS\u0016tG\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0003!\tX/Z;f+JdW#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00027b]\u001eT\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002\u0017w!1\u0011\t\u0001Q\u0001\ne\n\u0011\"];fk\u0016,&\u000f\u001c\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\u0007\u0005$G\r\u0006\u0002F\u0011B\u0011\u0001CR\u0005\u0003\u000fF\u0011A!\u00168ji\")\u0011J\u0011a\u0001\u001d\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\t\u000b-\u0003A\u0011\u0001'\u0002\u001d9,\u0007\u0010^%eK:$\u0018NZ5feR\tQ\nE\u0002\u0011\u001dBK!aT\t\u0003\r=\u0003H/[8o!\rY\u0011+O\u0005\u0003%\n\u0011a\"T3tg\u0006<Wm\u0016:baB,'\u000fC\u0003U\u0001\u0011\u0005Q+A\u0007sK6|g/Z'fgN\fw-\u001a\u000b\u0003\u000bZCQaV*A\u0002a\u000b1!\\:h!\rY\u0011K\u0004\u0005\u00065\u0002!\taW\u0001\u000eG>,h\u000e^'fgN\fw-Z:\u0016\u0003q\u0003\"\u0001E/\n\u0005y\u000b\"aA%oi\")\u0001\r\u0001C\u0001C\u0006A1\r\\3be\u0006cG\u000eF\u0001F\u0001")
public class AmazonSqsQueue
extends Queue<String>
implements Logging {
    private final String queueName;
    private final AmazonSQSClient client;
    private final String queueUrl;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        AmazonSqsQueue amazonSqsQueue = this;
        synchronized (amazonSqsQueue) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public String queueName() {
        return this.queueName;
    }

    private AmazonSQSClient client() {
        return this.client;
    }

    private String queueUrl() {
        return this.queueUrl;
    }

    @Override
    public void add(String identifier) {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding a new identifier ", " to queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier, this.queueName()})));
        this.client().sendMessage(new SendMessageRequest(this.queueUrl(), identifier));
    }

    @Override
    public Option<MessageWrapper<String>> nextIdentifier() {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking ", " for a new message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queueName()})));
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.queueUrl());
        receiveMessageRequest.setMaxNumberOfMessages(Predef$.MODULE$.int2Integer(1));
        receiveMessageRequest.setWaitTimeSeconds(Predef$.MODULE$.int2Integer(20));
        List messages = this.client().receiveMessage(receiveMessageRequest).getMessages();
        if (messages.isEmpty()) {
            this.log().debug(new StringBuilder().append((Object)"No message returned from queue ").append((Object)this.queueName()).toString());
        }
        return JavaConversions$.MODULE$.asScalaBuffer(messages).headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MessageWrapper<String> apply(Message m) {
                return new MessageWrapper<String>(m.getBody(), m.getReceiptHandle());
            }
        });
    }

    @Override
    public void removeMessage(MessageWrapper<String> msg) {
        this.log().debug(new StringBuilder().append((Object)"Removing message ").append((Object)msg.identifier()).append((Object)" from queue ").append((Object)this.queueName()).toString());
        this.client().deleteMessage(new DeleteMessageRequest(this.queueUrl(), msg.messageHandle()));
    }

    @Override
    public int countMessages() {
        GetQueueAttributesRequest request = new GetQueueAttributesRequest(this.queueUrl());
        request.setAttributeNames((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{QueueAttributeName.ApproximateNumberOfMessages.name(), QueueAttributeName.ApproximateNumberOfMessagesNotVisible.name()}))));
        java.util.Map attributes = this.client().getQueueAttributes(request).getAttributes();
        int visibleMessages = new StringOps(Predef$.MODULE$.augmentString((String)JavaConversions$.MODULE$.mapAsScalaMap(attributes).apply((Object)QueueAttributeName.ApproximateNumberOfMessages.name()))).toInt();
        int hiddenMessages = new StringOps(Predef$.MODULE$.augmentString((String)JavaConversions$.MODULE$.mapAsScalaMap(attributes).apply((Object)QueueAttributeName.ApproximateNumberOfMessagesNotVisible.name()))).toInt();
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queue ", " contains approximately ", " visible and ", " hidden messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queueName(), BoxesRunTime.boxToInteger((int)visibleMessages), BoxesRunTime.boxToInteger((int)hiddenMessages)})));
        return visibleMessages + hiddenMessages;
    }

    @Override
    public void clearAll() {
        List messages = this.getMessages$1();
        Random rnd = new Random();
        while (!messages.isEmpty()) {
            Buffer deleteRequests = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(messages).map((Function1)new Serializable(this, rnd){
                public static final long serialVersionUID = 0L;
                private final Random rnd$1;

                public final DeleteMessageBatchRequestEntry apply(Message m) {
                    return new DeleteMessageBatchRequestEntry(new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToLong((long)this.rnd$1.nextLong())).append((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString(), m.getReceiptHandle());
                }
                {
                    this.rnd$1 = rnd$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            this.client().deleteMessageBatch(new DeleteMessageBatchRequest(this.queueUrl(), JavaConversions$.MODULE$.bufferAsJavaList(deleteRequests)));
            messages = this.getMessages$1();
        }
        return;
    }

    private final List getMessages$1() {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.queueUrl());
        receiveMessageRequest.setMaxNumberOfMessages(Predef$.MODULE$.int2Integer(10));
        receiveMessageRequest.setWaitTimeSeconds(Predef$.MODULE$.int2Integer(0));
        return this.client().receiveMessage(receiveMessageRequest).getMessages();
    }

    /*
     * WARNING - void declaration
     */
    public AmazonSqsQueue(String queueName) {
        void var2_2;
        this.queueName = queueName;
        Logging$class.$init$(this);
        AmazonSQSClient sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        sqs.setRegion(Region.getRegion((Regions)Regions.US_WEST_2));
        this.client = var2_2;
        CreateQueueRequest createRequest = new CreateQueueRequest(queueName);
        createRequest.setAttributes(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)QueueAttributeName.VisibilityTimeout.name()), (Object)"120")}))));
        this.log().debug(new StringBuilder().append((Object)"Starting Amazon SQS queue with name ").append((Object)queueName).toString());
        this.queueUrl = this.client().createQueue(createRequest).getQueueUrl();
    }
}

