/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.javaflow.spi.AbstractResourceTransformer;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.apache.commons.javaflow.spi.ResourceTransformationFactory;
import org.apache.commons.javaflow.spi.ResourceTransformer;

public class CompositeResourceTransformer
extends AbstractResourceTransformer {
    private final ResourceTransformer[] transformers;

    public CompositeResourceTransformer(ResourceTransformer[] transformers) {
        this.transformers = transformers;
    }

    @Override
    public byte[] transform(byte[] image, Collection<String> retransformClasses) {
        for (ResourceTransformer transformer : this.transformers) {
            byte[] result = transformer.transform(image, retransformClasses);
            if (null == result) continue;
            image = result;
        }
        return image;
    }

    @Override
    public void release() {
        for (ResourceTransformer transformer : this.transformers) {
            transformer.release();
        }
    }

    public static ResourceTransformationFactory composeFactories(ResourceTransformationFactory ... factories) {
        return CompositeResourceTransformer.composeFactories(Arrays.asList(factories));
    }

    public static ResourceTransformationFactory composeFactories(final List<ResourceTransformationFactory> factories) {
        return new ResourceTransformationFactory(){

            @Override
            public String readClassName(byte[] classBytes) {
                if (factories.isEmpty()) {
                    throw new IllegalStateException("No factories to perform operation");
                }
                return ((ResourceTransformationFactory)factories.get(0)).readClassName(classBytes);
            }

            @Override
            public ResourceTransformer createTransformer(ResourceLoader resourceLoader) {
                ResourceTransformer[] transformers = new ResourceTransformer[factories.size()];
                int idx = 0;
                for (ResourceTransformationFactory factory : factories) {
                    transformers[idx++] = factory.createTransformer(resourceLoader);
                }
                return new CompositeResourceTransformer(transformers);
            }
        };
    }
}

