/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.javaflow.spi.ClassMatchStrategies;
import org.apache.commons.javaflow.spi.ClassMatchStrategy;

class ClassMatchStrategyFileParser {
    private static final Map<String, StrategyFactory> STRATEGY_FACTORIES;

    ClassMatchStrategyFileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassMatchStrategy parse(URL url) throws IOException {
        ArrayList<ClassMatchStrategy> matchers = new ArrayList<ClassMatchStrategy>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openStream()));
        try {
            String s;
            int lineIdx = 0;
            while (null != (s = ((BufferedReader)reader).readLine())) {
                if (s.length() == 0 || s.startsWith("#")) continue;
                int columnPos = s.indexOf(58);
                int equalsPos = s.indexOf(61);
                if (columnPos < 0 || equalsPos < 0) {
                    throw new IOException("Unparsable entry at line #" + lineIdx + " (invalid kind/variant) of " + url.toExternalForm());
                }
                String kind = s.substring(0, columnPos).trim();
                String variant = s.substring(columnPos + 1, equalsPos).trim();
                String target = s.substring(equalsPos + 1).trim();
                if (target.length() == 0) {
                    throw new IOException("Unparsable entry at line #" + lineIdx + " (missing name/name-part/pattern) of " + url.toExternalForm());
                }
                StrategyFactory factory = STRATEGY_FACTORIES.get(kind + ':' + variant);
                if (null == factory) {
                    throw new IOException("Unknown kind/variant \"" + kind + ':' + variant + "\" at line #" + lineIdx + url.toExternalForm());
                }
                matchers.add(factory.create(target));
                ++lineIdx;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return matchers.isEmpty() ? ClassMatchStrategies.MATCH_NONE : ClassMatchStrategies.whenAny(matchers);
    }

    static {
        HashMap<String, StrategyFactory> map = new HashMap<String, StrategyFactory>();
        String[] keys = new String[]{"class:name", "class:name-part", "class:name-pattern", "extends-class:name", "extends-class:name-part", "extends-class:name-pattern", "implements-interface:name", "implements-interface:name-part", "implements-interface:name-pattern"};
        int idx = 0;
        for (KindFactory kindFactory : KindFactory.values()) {
            for (VariantFactory variantFactory : VariantFactory.values()) {
                map.put(keys[idx++], kindFactory.compose(variantFactory));
            }
        }
        STRATEGY_FACTORIES = Collections.unmodifiableMap(map);
    }

    static enum KindFactory {
        CLASS{

            @Override
            ClassMatchStrategy create(ClassMatchStrategy nested) {
                return nested;
            }
        }
        ,
        EXTENDS_CLASS{

            @Override
            ClassMatchStrategy create(ClassMatchStrategy nested) {
                return ClassMatchStrategies.bySuperClass(nested);
            }
        }
        ,
        IMPLEMENTS_INTERFACE{

            @Override
            ClassMatchStrategy create(ClassMatchStrategy nested) {
                return ClassMatchStrategies.byInterface(nested);
            }
        };


        abstract ClassMatchStrategy create(ClassMatchStrategy var1);

        StrategyFactory compose(final VariantFactory nested) {
            return new StrategyFactory(){

                @Override
                public ClassMatchStrategy create(String option) {
                    return KindFactory.this.create(nested.create(option));
                }
            };
        }
    }

    static enum VariantFactory implements StrategyFactory
    {
        NAME_FULL{

            @Override
            public ClassMatchStrategy create(String option) {
                return ClassMatchStrategies.byClassName(option, false);
            }
        }
        ,
        NAME_PART{

            @Override
            public ClassMatchStrategy create(String option) {
                return ClassMatchStrategies.byClassName(option, true);
            }
        }
        ,
        NAME_PATTERN{

            @Override
            public ClassMatchStrategy create(String option) {
                return ClassMatchStrategies.byClassNamePattern(option);
            }
        };

    }

    static interface StrategyFactory {
        public ClassMatchStrategy create(String var1);
    }
}

