/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.javaflow.spi.ClassMatchStrategies;
import org.apache.commons.javaflow.spi.ClassMatchStrategy;
import org.apache.commons.javaflow.spi.ClassMatchStrategyFileParser;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.VetoableResourceLoader;

public class ClasspathResourceLoader
implements VetoableResourceLoader {
    private final Reference<ClassLoader> classLoaderRef;

    public ClasspathResourceLoader(ClassLoader classLoader) {
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    public boolean hasResource(String name) {
        ClassLoader classLoader = this.classLoaderRef.get();
        return null != classLoader && null != classLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) throws IOException {
        ClassLoader classLoader = this.classLoaderRef.get();
        if (null == classLoader) {
            throw new IOException("Underlying class loader was evicted from memory, this resource loader is unusable");
        }
        InputStream result = classLoader.getResourceAsStream(name);
        if (null == result) {
            throw new IOException("Unable to find resource " + name);
        }
        return result;
    }

    @Override
    public ClassMatcher createVeto() throws IOException {
        return this.getVetoStrategy().bind(this);
    }

    @Override
    public ClassMatchStrategy getVetoStrategy() throws IOException {
        ArrayList<ClassMatchStrategy> strategies = new ArrayList<ClassMatchStrategy>();
        ClassLoader classLoader = this.classLoaderRef.get();
        if (null == classLoader) {
            return ClassMatchStrategies.MATCH_NONE;
        }
        Enumeration<URL> allResources = classLoader.getResources("META-INF/net.tascalate.javaflow.veto.cmf");
        ClassMatchStrategyFileParser parser = new ClassMatchStrategyFileParser();
        while (allResources.hasMoreElements()) {
            URL resource = allResources.nextElement();
            ClassMatchStrategy strategy = parser.parse(resource);
            if (null == strategy || ClassMatchStrategies.MATCH_NONE == strategy) continue;
            strategies.add(strategy);
        }
        return strategies.isEmpty() ? ClassMatchStrategies.MATCH_NONE : ClassMatchStrategies.whenAny(strategies);
    }
}

