/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.javaflow.spi.ClassHeaderReader;

public final class InstrumentationUtils {
    private InstrumentationUtils() {
    }

    public static String packageNameOf(Class<?> clazz) {
        String className = clazz.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            return className.substring(0, lastDot);
        }
        return null;
    }

    public static Set<String> packagePrefixesOf(Class<?> ... classes) {
        HashSet<String> packagePrefixes = new HashSet<String>();
        for (Class<?> clazz : classes) {
            packagePrefixes.add(InstrumentationUtils.packageNameOf(clazz) + '.');
        }
        return packagePrefixes;
    }

    public static String readClassName(byte[] bytes) {
        return new ClassHeaderReader(bytes).getClassName();
    }

    public static boolean isClassLoaderParent(ClassLoader classLoader, ClassLoader maybeParent) {
        ClassLoader cl = classLoader;
        do {
            if (maybeParent != (cl = cl.getParent())) continue;
            return true;
        } while (cl != null);
        return false;
    }
}

