/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.javaflow.spi.ResourceTransformer;
import org.apache.commons.javaflow.tools.jar.RewritingUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;

public class ContinuableClassesInstrumentationTask
extends MatchingTask {
    private File dstDir;
    private File srcDir;
    private Path compileClasspath;

    public void setDestdir(File pFile) {
        this.dstDir = pFile;
    }

    public void setSrcDir(File pFile) {
        this.srcDir = pFile;
        this.fileset.setDir(this.srcDir);
    }

    @Deprecated
    public void setMode(String name) {
        try {
            RewritingUtils.TransformerType.valueOf((String)name.toUpperCase());
        }
        catch (RuntimeException ex) {
            throw new BuildException("Unrecognized mode: " + name);
        }
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    protected void checkParameters() throws BuildException {
        this.checkDir(this.srcDir, "srcDir");
        this.checkDir(this.dstDir, "dstDir");
    }

    private void checkDir(File pDir, String pDescription) {
        if (pDir == null) {
            throw new BuildException("no " + pDescription + " directory is specified", this.getLocation());
        }
        if (!pDir.exists()) {
            throw new BuildException(pDescription + " directory \"" + pDir + "\" does not exist", this.getLocation());
        }
        if (!pDir.isDirectory()) {
            throw new BuildException(pDescription + " directory \"" + pDir + "\" is not a directory", this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        DirectoryScanner ds = this.fileset.getDirectoryScanner(this.getProject());
        String[] fileNames = ds.getIncludedFiles();
        try {
            this.createClasspath();
            ArrayList<URL> classPath = new ArrayList<URL>();
            for (FileResource resource : this.compileClasspath) {
                classPath.add(resource.getFile().toURI().toURL());
            }
            ArrayList<URL> classPathByDir = new ArrayList<URL>(classPath);
            classPathByDir.add(this.srcDir.toURI().toURL());
            ResourceTransformer dirTransformer = RewritingUtils.createTransformer((URL[])classPathByDir.toArray(new URL[0]));
            try {
                for (String fileName : fileNames) {
                    File source = new File(this.srcDir, fileName);
                    File destination = new File(this.dstDir, fileName);
                    if (!destination.getParentFile().exists()) {
                        this.log("Creating dir: " + destination.getParentFile(), 3);
                        destination.getParentFile().mkdirs();
                    }
                    if (source.lastModified() < destination.lastModified()) {
                        this.log("Omitting " + source + " as " + destination + " is up to date", 3);
                        continue;
                    }
                    if (fileName.endsWith(".class")) {
                        this.log("Rewriting " + source + " to " + destination, 3);
                        RewritingUtils.rewriteClassFile((File)source, (ResourceTransformer)dirTransformer, (File)destination);
                    }
                    if (!fileName.endsWith(".jar") && !fileName.endsWith(".ear") && !fileName.endsWith(".zip") && !fileName.endsWith(".war")) continue;
                    this.log("Rewriting " + source + " to " + destination, 3);
                    ArrayList<URL> classPathByJar = new ArrayList<URL>(classPath);
                    classPathByJar.add(source.toURI().toURL());
                    ResourceTransformer jarTransformer = RewritingUtils.createTransformer((URL[])classPathByJar.toArray(new URL[0]));
                    try {
                        RewritingUtils.rewriteJar((JarInputStream)new JarInputStream(new FileInputStream(source)), (ResourceTransformer)jarTransformer, (JarOutputStream)new JarOutputStream(new FileOutputStream(destination)));
                    }
                    finally {
                        jarTransformer.release();
                    }
                }
            }
            finally {
                dirTransformer.release();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

