/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.tools.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.javaflow.providers.core.ContinuableClassTransformationFactory;
import org.apache.commons.javaflow.spi.AbstractResourceTransformer;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.FastByteArrayOutputStream;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.apache.commons.javaflow.spi.ResourceTransformationFactory;
import org.apache.commons.javaflow.spi.ResourceTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RewritingUtils {
    private static final Logger log = LoggerFactory.getLogger(RewritingUtils.class);
    private static Matcher MATCH_ALL = new Matcher(){

        @Override
        public boolean isMatching(String pName) {
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rewriteClassFile(File input, ResourceTransformer transformer, File output) throws IOException {
        byte[] original = RewritingUtils.toByteArray(input);
        byte[] transformed = transformer.transform(original);
        if (transformed != original || !output.equals(input)) {
            FileOutputStream os = new FileOutputStream(output);
            try {
                os.write(transformed);
            }
            finally {
                os.close();
            }
            return true;
        }
        return false;
    }

    public static boolean rewriteJar(JarInputStream input, ResourceTransformer transformer, JarOutputStream output) throws IOException {
        return RewritingUtils.rewriteJar(input, transformer, output, MATCH_ALL);
    }

    public static boolean rewriteJar(JarInputStream input, ResourceTransformer transformer, JarOutputStream output, Matcher pMatcher) throws IOException {
        JarEntry entry;
        boolean changed = false;
        while ((entry = input.getNextJarEntry()) != null) {
            if (entry.isDirectory()) {
                output.putNextEntry(new JarEntry(entry));
                continue;
            }
            String name = entry.getName();
            output.putNextEntry(new JarEntry(name));
            if (name.endsWith(".class")) {
                if (pMatcher.isMatching(name)) {
                    if (log.isDebugEnabled()) {
                        log.debug("transforming " + name);
                    }
                    byte[] original = RewritingUtils.toByteArray(input);
                    byte[] transformed = transformer.transform(original);
                    output.write(transformed);
                    changed |= transformed.length != original.length;
                    continue;
                }
            } else if (name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war")) {
                changed |= RewritingUtils.rewriteJar(new JarInputStream(input), transformer, new JarOutputStream(output), pMatcher);
                continue;
            }
            int length = RewritingUtils.copy(input, output);
            log.debug("copied " + name + "(" + length + ")");
        }
        input.close();
        output.close();
        return changed;
    }

    public static byte[] toByteArray(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            byte[] byArray = RewritingUtils.toByteArray(in);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        RewritingUtils.copy(in, (OutputStream)baos);
        return baos.unsafeBytes();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        int total = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
            total += n;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException {
        ResourceTransformationFactory factory = RewritingUtils.createTransformerFactoryInstance();
        for (int i = 0; i < args.length; i += 2) {
            System.out.println("rewriting " + args[i]);
            ResourceTransformer transformer = RewritingUtils.createTransformer(new URL[]{new File(args[i]).toURI().toURL()}, factory);
            try {
                RewritingUtils.rewriteJar(new JarInputStream(new FileInputStream(args[i])), transformer, new JarOutputStream(new FileOutputStream(args[i + 1])));
                continue;
            }
            finally {
                transformer.release();
            }
        }
        System.out.println("done");
    }

    public static ResourceTransformer createTransformer(URL[] extraURL) {
        return RewritingUtils.createTransformer(extraURL, RewritingUtils.createTransformerFactoryInstance());
    }

    public static ResourceTransformer createTransformer(URL[] extraURL, ResourceTransformationFactory factory) {
        final URLClassLoader classLoader = new URLClassLoader(extraURL, RewritingUtils.safeParentClassLoader());
        final ResourceTransformer transformerDelegate = factory.createTransformer((ResourceLoader)new ClasspathResourceLoader((ClassLoader)classLoader));
        return new AbstractResourceTransformer(){
            private final Object hardReference;
            {
                this.hardReference = classLoader;
            }

            public byte[] transform(byte[] original, Collection<String> retransformClasses) {
                byte[] transformed = transformerDelegate.transform(original, retransformClasses);
                return null != transformed ? transformed : original;
            }

            public void release() {
                transformerDelegate.release();
            }
        };
    }

    private static ClassLoader safeParentClassLoader() {
        ClassLoader ownClassLoader = RewritingUtils.class.getClassLoader();
        return null == ownClassLoader ? ClassLoader.getSystemClassLoader() : ownClassLoader;
    }

    public static ResourceTransformationFactory createTransformerFactoryInstance() {
        return new ContinuableClassTransformationFactory();
    }

    @Deprecated
    public static ResourceTransformer createTransformer(URL[] extraURL, TransformerType type) {
        return RewritingUtils.createTransformer(extraURL, RewritingUtils.createTransformerFactoryInstance(type));
    }

    @Deprecated
    public static ResourceTransformationFactory createTransformerFactoryInstance(TransformerType transformerType) {
        Class<? extends ResourceTransformationFactory> transformerFactoryClass;
        if (null == transformerType) {
            transformerFactoryClass = RewritingUtils.getDefaultResourceTransformerFactoryClass();
        } else {
            try {
                transformerFactoryClass = transformerType.implementaion();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return transformerFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<? extends ResourceTransformationFactory> getDefaultResourceTransformerFactoryClass() {
        for (TransformerType transformerType : TransformerType.values()) {
            try {
                return transformerType.implementaion();
            }
            catch (ClassNotFoundException ex) {
                System.err.println(ex);
            }
        }
        throw new RuntimeException("No bytecode transformation class is found for JavaFlow bytecode modifications");
    }

    @Deprecated
    public static enum TransformerType {
        ASMX("org.apache.commons.javaflow.providers.core.ContinuableClassTransformationFactory"),
        ASM5("org.apache.commons.javaflow.providers.asm5.Asm5ResourceTransformationFactory"),
        ASM4("org.apache.commons.javaflow.providers.asm4.Asm4ResourceTransformationFactory"),
        ASM3("org.apache.commons.javaflow.providers.asm3.Asm3ResourceTransformationFactory"),
        BCEL("org.apache.commons.javaflow.providers.bcel.BcelResourceTransformationFactory");

        private String implementation;

        private TransformerType(String implementation) {
            this.implementation = implementation;
        }

        Class<? extends ResourceTransformationFactory> implementaion() throws ClassNotFoundException {
            Class<?> c = Class.forName(this.implementation);
            return c;
        }
    }

    public static interface Matcher {
        public boolean isMatching(String var1);
    }
}

