/**
 * Copyright 2015-2021 Valery Silaev (http://vsilaev.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.tascalate.concurrent;

import java.util.concurrent.Callable;

@FunctionalInterface
public interface RetryCallable<V, T> {
    V call(RetryContext<T> ctx) throws Exception;
    
    public static <V, T> RetryCallable<V, T> from(Callable<? extends V> callable) {
        return ctx -> callable.call();
    }
    
    public static RetryCallable<Void, Void> from(RetryRunnable runnable) {
        return ctx -> { 
            runnable.run(ctx); 
            return null; 
        };
    }
    
    public static RetryCallable<Void, Void> from(Runnable runnable) {
        return RetryCallable.from(RetryRunnable.from(runnable));
    }
}
