/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.tascalate.concurrent.CallbackRegistry;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseAdapterExtended;
import net.tascalate.concurrent.SharedFunctions;

abstract class AbstractCompletableTask<T>
extends PromiseAdapterExtended<T>
implements Promise<T> {
    private final CallbackRegistry<T> callbackRegistry = new CallbackRegistry();
    protected final RunnableFuture<T> task;
    private volatile CompletionStage<?> intermediateStage;

    protected AbstractCompletableTask(Executor defaultExecutor, Callable<T> action) {
        super(defaultExecutor);
        this.task = new FutureTask<T>(action){

            @Override
            protected void set(T v) {
                super.set(v);
                AbstractCompletableTask.this.success(v);
            }

            @Override
            protected void setException(Throwable t) {
                super.setException(t);
                AbstractCompletableTask.this.failure(t);
            }
        };
    }

    abstract void fireTransition(Callable<T> var1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.task.cancel(mayInterruptIfRunning)) {
            this.failure(new CancellationException());
            CompletionStage<?> s = this.intermediateStage;
            if (null != s) {
                SharedFunctions.cancelPromise(s, mayInterruptIfRunning);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.task.get();
        }
        catch (ExecutionException ex) {
            throw AbstractCompletableTask.rewrapExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)this.task.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw AbstractCompletableTask.rewrapExecutionException(ex);
        }
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.callbackRegistry.isFailure();
    }

    boolean success(T result) {
        return this.callbackRegistry.success(result);
    }

    boolean failure(Throwable ex) {
        return this.callbackRegistry.failure(ex);
    }

    public String toString() {
        return String.format("%s@%d[%s]", this.getClass().getSimpleName(), System.identityHashCode(this), this.task);
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.addCallbacks(this.newSubTask(executor), r -> {
            try {
                return fn.apply(r);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
        }, AbstractCompletableTask.forwardException(), executor);
    }

    @Override
    public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.addCallbacks(this.newSubTask(executor), Function.identity(), failure -> {
            try {
                return fn.apply((Throwable)failure);
            }
            catch (Throwable e) {
                if (e != failure) {
                    e.addSuppressed((Throwable)failure);
                }
                return AbstractCompletableTask.forwardException(e);
            }
        }, executor);
    }

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.addCallbacks(this.newSubTask(executor), result -> {
            try {
                return fn.apply(result, null);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
        }, failure -> {
            try {
                return fn.apply((Object)null, (Throwable)failure);
            }
            catch (Throwable e) {
                if (e != failure) {
                    e.addSuppressed((Throwable)failure);
                }
                return AbstractCompletableTask.forwardException(e);
            }
        }, executor);
    }

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        AbstractCompletableTask<U> tempStage = this.newSubTask(executor);
        AbstractCompletableTask nextStage = this.newSubTask(executor);
        nextStage.intermediateStage = tempStage;
        Consumer onResult = super.runTransition(Function.identity());
        Consumer<Throwable> onError = super.runTransition(AbstractCompletableTask.forwardException());
        this.addCallbacks(tempStage, r -> {
            try {
                CompletionStage returned;
                nextStage.intermediateStage = null;
                if (nextStage.isDone()) {
                    return null;
                }
                nextStage.intermediateStage = returned = (CompletionStage)fn.apply(r);
                if (nextStage.isCancelled()) {
                    SharedFunctions.cancelPromise(returned, true);
                } else {
                    returned.whenComplete(AbstractCompletableTask.biConsumer(onResult, onError));
                }
            }
            catch (Throwable e) {
                onError.accept(e);
            }
            return null;
        }, AbstractCompletableTask.consumerAsFunction(onError), executor);
        return nextStage;
    }

    @Override
    public Promise<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        AbstractCompletableTask tempStage = this.newSubTask(executor);
        AbstractCompletableTask nextStage = this.newSubTask(executor);
        nextStage.intermediateStage = tempStage;
        Consumer onResult = super.runTransition(Function.identity());
        Consumer<Throwable> onError = super.runTransition(AbstractCompletableTask.forwardException());
        this.addCallbacks(tempStage, AbstractCompletableTask.consumerAsFunction(onResult), failure -> {
            try {
                CompletionStage returned;
                nextStage.intermediateStage = null;
                if (nextStage.isDone()) {
                    return null;
                }
                nextStage.intermediateStage = returned = (CompletionStage)fn.apply((Throwable)failure);
                if (nextStage.isCancelled()) {
                    SharedFunctions.cancelPromise(returned, true);
                } else {
                    returned.whenComplete(AbstractCompletableTask.biConsumer(onResult, onError));
                }
            }
            catch (Throwable e) {
                if (e != failure) {
                    e.addSuppressed((Throwable)failure);
                }
                onError.accept(e);
            }
            return null;
        }, executor);
        return nextStage;
    }

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.addCallbacks(this.newSubTask(executor), result -> {
            try {
                action.accept(result, null);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
            return result;
        }, failure -> {
            block2: {
                try {
                    action.accept((Object)null, (Throwable)failure);
                }
                catch (Throwable e) {
                    if (e == failure) break block2;
                    failure.addSuppressed(e);
                }
            }
            return AbstractCompletableTask.forwardException(failure);
        }, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture result = new CompletableFuture();
        this.whenComplete((T r, U e) -> SharedFunctions.iif(e == null ? result.complete(r) : result.completeExceptionally((Throwable)e)));
        return result;
    }

    @Override
    protected <R, U> Promise<U> doApplyToEitherAsync(CompletionStage<? extends R> first, CompletionStage<? extends R> second, Function<? super R, U> fn, Executor executor) {
        AbstractCompletableTask nextStage = this.newSubTask(executor);
        BiConsumer<Object, Throwable> action = (r, e) -> SharedFunctions.iif(e == null ? nextStage.success(r) : nextStage.failure((Throwable)AbstractCompletableTask.forwardException(e)));
        first.whenComplete(action);
        second.whenComplete(action);
        return nextStage.thenApplyAsync(fn, executor);
    }

    protected abstract <U> AbstractCompletableTask<U> createCompletionStage(Executor var1);

    private <U> AbstractCompletableTask<U> newSubTask(Executor executor) {
        return this.createCompletionStage(executor == SAME_THREAD_EXECUTOR ? this.getDefaultExecutor() : executor);
    }

    private <U> Consumer<? super U> runTransition(Function<? super U, ? extends T> converter) {
        return u -> this.fireTransition(() -> converter.apply((Object)u));
    }

    private static <U, V> BiConsumer<U, V> biConsumer(Consumer<? super U> onResult, Consumer<? super V> onError) {
        return (u, v) -> {
            if (null == v) {
                onResult.accept((Object)u);
            } else {
                onError.accept((Object)v);
            }
        };
    }

    private static ExecutionException rewrapExecutionException(ExecutionException ex) {
        return SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(SharedFunctions.unwrapExecutionException(ex)));
    }

    private <U> AbstractCompletableTask<U> addCallbacks(AbstractCompletableTask<U> targetStage, Function<? super T, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
        this.callbackRegistry.addCallbacks(targetStage, successCallback, failureCallback, executor);
        return targetStage;
    }
}

