/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public abstract class AbstractThreadFactoryBuilder<T extends AbstractThreadFactoryBuilder<T>> {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger();
    private static final String DEFAULT_NAME_FORMAT = "pool-%3$d-thread-%1$d";
    private String nameFormat = "pool-%3$d-thread-%1$d";
    private ThreadGroup threadGroup = null;
    private ClassLoader contextClassLoader = null;
    private Boolean isDaemon = null;
    private boolean isPriviledged = false;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;

    protected AbstractThreadFactoryBuilder() {
    }

    private T self() {
        return (T)this;
    }

    public T withNameFormat(String nameFormat) {
        this.nameFormat = nameFormat == null || nameFormat.isEmpty() ? DEFAULT_NAME_FORMAT : nameFormat;
        return this.self();
    }

    public T withDefaultNameFormat() {
        return this.withNameFormat(DEFAULT_NAME_FORMAT);
    }

    public T withThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        return this.self();
    }

    public T withContextClassLoader(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
        return this.self();
    }

    public T withPriviledgedAccess(boolean isPriviledged) {
        this.isPriviledged = isPriviledged;
        return this.self();
    }

    public T withDaemonFlag(boolean daemon) {
        this.isDaemon = daemon;
        return this.self();
    }

    public T withDefaultDaemonFlag() {
        this.isDaemon = null;
        return this.self();
    }

    public T withPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException(String.format("Thread priority (%d) must be within [%d..%d]", priority, 1, 10));
        }
        this.priority = priority;
        return this.self();
    }

    public T withDefaultPriority() {
        this.priority = null;
        return this.self();
    }

    public T withUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        return this.self();
    }

    public ThreadFactory build() {
        return this.makeConfigured(this.makePriviledged(this.makeDefault(POOL_COUNTER.getAndIncrement(), this.nameFormat, this.threadGroup), this.isPriviledged, this.contextClassLoader), this.isDaemon, this.priority, this.uncaughtExceptionHandler);
    }

    protected abstract Thread createThread(ThreadGroup var1, Runnable var2, String var3);

    protected ThreadFactory makeDefault(int poolCounter, String nameFormat, ThreadGroup threadGroup) {
        SecurityManager sm;
        ThreadGroup actualThreadGroup = null == threadGroup ? (null != (sm = System.getSecurityManager()) ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup()) : threadGroup;
        AtomicInteger threadCounter = new AtomicInteger(0);
        return r -> this.createThread(actualThreadGroup, r, String.format(Locale.getDefault(), nameFormat, threadCounter.getAndIncrement(), actualThreadGroup.getName(), poolCounter));
    }

    protected ThreadFactory makePriviledged(ThreadFactory origin, boolean isPriviledged, ClassLoader contextClassLoader) {
        if (isPriviledged) {
            ClassLoader actualClassLoader;
            if (null == contextClassLoader) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new RuntimePermission("getClassLoader"));
                }
                actualClassLoader = Thread.currentThread().getContextClassLoader();
            } else {
                actualClassLoader = contextClassLoader;
            }
            AccessControlContext ctx = AccessController.getContext();
            return this.makeContextual(origin, actualClassLoader, r -> () -> AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    r.run();
                    return null;
                }
            }, ctx));
        }
        return this.makeContextual(origin, contextClassLoader);
    }

    private ThreadFactory makeContextual(ThreadFactory origin, ClassLoader contextClassLoader) {
        return this.makeContextual(origin, contextClassLoader, Function.identity());
    }

    protected ThreadFactory makeContextual(ThreadFactory origin, ClassLoader contextClassLoader, Function<? super Runnable, ? extends Runnable> wrapper) {
        if (null == contextClassLoader) {
            return origin;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        return r -> {
            Runnable contextualRunnable = () -> {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
                r.run();
            };
            return origin.newThread((Runnable)wrapper.apply(contextualRunnable));
        };
    }

    protected ThreadFactory makeConfigured(ThreadFactory origin, Boolean isDaemon, Integer priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (null == isDaemon && null == priority && null == uncaughtExceptionHandler) {
            return origin;
        }
        return r -> {
            Thread t = origin.newThread(r);
            if (null != priority && priority.intValue() != t.getPriority()) {
                t.setPriority(priority);
            }
            if (null != isDaemon && isDaemon.booleanValue() != t.isDaemon()) {
                t.setDaemon(isDaemon);
            }
            if (null != uncaughtExceptionHandler) {
                t.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
            return t;
        };
    }
}

