/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.MultitargetException;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.SharedFunctions;

abstract class AggregatingPromise<T, R>
extends CompletableFutureWrapper<List<R>> {
    private final List<Throwable> errors;
    private final AtomicIntegerArray completions;
    private final AtomicInteger resultsCount = new AtomicInteger(0);
    private final AtomicInteger errorsCount = new AtomicInteger(0);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final int minResultsCount;
    private final int maxErrorsCount;
    private final boolean cancelRemaining;
    private final List<? extends CompletionStage<? extends T>> promises;
    private static final int PENDING = 0;
    private static final int COMPLETED_RESULT = 1;
    private static final int COMPLETED_ERROR = 2;
    private static final int COMPLETED_CANCEL = -1;

    static <T> Constructor<T, Optional<T>> newWithAllResults() {
        return (minResultsCount, maxErrorsCount, cancelRemaining, promises) -> new AggregatingPromise<T, Optional<T>>(minResultsCount, maxErrorsCount, cancelRemaining, promises){
            private final List results;
            {
                super(minResultsCount, maxErrorsCount, cancelRemaining, promises2);
                this.results = AggregatingPromise.newList(promises.size());
            }

            @Override
            void applyResult(int idx, T value) {
                this.results.set(idx, Optional.ofNullable(value));
            }

            @Override
            List<Optional<T>> collectResults(int resultsCount, AtomicIntegerArray completions) {
                return Collections.unmodifiableList(this.results);
            }
        };
    }

    static <T> Constructor<T, T> newWithSuccessResults() {
        return (minResultsCount, maxErrorsCount, cancelRemaining, promises) -> new AggregatingPromise<T, T>(minResultsCount, maxErrorsCount, cancelRemaining, promises){
            private final List results;
            {
                super(minResultsCount, maxErrorsCount, cancelRemaining, promises2);
                this.results = AggregatingPromise.newList(promises.size());
            }

            @Override
            void applyResult(int idx, T value) {
                this.results.set(idx, value);
            }

            @Override
            List<T> collectResults(int resultsCount, AtomicIntegerArray completions) {
                ArrayList collectedResult = new ArrayList(resultsCount);
                int size = completions.length();
                for (int k = 0; k < size; ++k) {
                    if (completions.get(k) != 1) continue;
                    collectedResult.add(this.results.get(k));
                }
                return Collections.unmodifiableList(collectedResult);
            }
        };
    }

    static <T> Constructor<T, Void> newWithEmptyResults() {
        return (minResultsCount, maxErrorsCount, cancelRemaining, promises) -> new AggregatingPromise<T, Void>(minResultsCount, maxErrorsCount, cancelRemaining, promises){

            @Override
            void applyResult(int idx, T value) {
            }

            @Override
            List<Void> collectResults(int resultsCount, AtomicIntegerArray completions) {
                return Collections.emptyList();
            }
        };
    }

    AggregatingPromise(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        if (null == promises || promises.isEmpty()) {
            throw new IllegalArgumentException("There are should be at least one promise specified");
        }
        int size = promises.size();
        this.promises = promises;
        this.minResultsCount = minResultsCount < 0 ? size : Math.max(1, Math.min(size, minResultsCount));
        this.maxErrorsCount = maxErrorsCount < 0 ? promises.size() - minResultsCount : Math.max(0, Math.min(maxErrorsCount, size - minResultsCount));
        this.cancelRemaining = cancelRemaining;
        this.errors = AggregatingPromise.newList(size);
        this.completions = new AtomicIntegerArray(size);
    }

    abstract void applyResult(int var1, T var2);

    abstract List<R> collectResults(int var1, AtomicIntegerArray var2);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done.compareAndSet(false, true)) {
            this.markRemainingCancelled();
            this.cancelPromises();
            return super.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    void onComplete(int idx, T result, Throwable error) {
        if (!this.completions.compareAndSet(idx, 0, null == error ? 1 : 2)) {
            return;
        }
        if (null == error) {
            int c = this.resultsCount.incrementAndGet();
            if (c <= this.minResultsCount) {
                this.applyResult(idx, result);
                if (c == this.minResultsCount && this.done.compareAndSet(false, true)) {
                    this.markRemainingCancelled();
                    if (this.cancelRemaining) {
                        this.cancelPromises();
                    }
                    this.success(this.collectResults(this.minResultsCount, this.completions));
                }
            }
        } else {
            int c = this.errorsCount.getAndIncrement();
            if (c <= this.maxErrorsCount) {
                this.errors.set(idx, error);
                if (c == this.maxErrorsCount && this.done.compareAndSet(false, true)) {
                    this.markRemainingCancelled();
                    if (this.cancelRemaining) {
                        this.cancelPromises();
                    }
                    this.failure(new MultitargetException(String.format(c == 1 ? "Aggregated promise was completed exceptionally (1 out of %d)" : "Aggregated promises were completed exceptionally (%2$d out of %1$d)", this.promises.size(), c), this.errors));
                }
            }
        }
    }

    Promise<List<R>> start() {
        int i = 0;
        for (CompletionStage<Object> completionStage : this.promises) {
            int idx = i++;
            completionStage.whenComplete((? super T r, ? super Throwable e) -> this.onComplete(idx, (T)r, (Throwable)e));
        }
        return this;
    }

    private void markRemainingCancelled() {
        for (int idx = this.completions.length() - 1; idx >= 0; --idx) {
            this.completions.compareAndSet(idx, 0, -1);
        }
    }

    private void cancelPromises() {
        int i = 0;
        for (CompletionStage<? extends T> completionStage : this.promises) {
            if (this.completions.get(i++) != -1) continue;
            SharedFunctions.cancelPromise(completionStage, true);
        }
    }

    private static <T> List<T> newList(int length) {
        return new ArrayList<Object>(Collections.nCopies(length, null));
    }

    @FunctionalInterface
    static interface Constructor<T, R> {
        public AggregatingPromise<T, R> create(int var1, int var2, boolean var3, List<? extends CompletionStage<? extends T>> var4);
    }
}

