/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.SharedFunctions;

class AsyncLoop<T>
extends CompletableFutureWrapper<T> {
    private final Predicate<? super T> loopCondition;
    private final Function<? super T, ? extends CompletionStage<T>> loopBody;
    private volatile CompletionStage<T> currentStage;

    AsyncLoop(Predicate<? super T> loopCondition, Function<? super T, ? extends CompletionStage<T>> loopBody) {
        this.loopCondition = loopCondition;
        this.loopBody = loopBody;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            CompletionStage<T> s = this.currentStage;
            if (null != s) {
                SharedFunctions.cancelPromise(s, mayInterruptIfRunning);
            }
            return true;
        }
        return false;
    }

    void run(T initialValue) {
        this.run(initialValue, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(T resolvedValue, Thread initialThread, IterationState<T> initialState) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(initialThread) && initialState.running) {
            initialState.put(resolvedValue);
            return;
        }
        IterationState currentState = new IterationState();
        T currentValue = resolvedValue;
        try {
            do {
                try {
                    if (this.isDone()) {
                        break;
                    }
                    if (this.loopCondition.test(currentValue)) {
                        CompletionStage<Object> returned = this.loopBody.apply(currentValue);
                        this.currentStage = returned;
                        if (this.isDone()) {
                            SharedFunctions.cancelPromise(returned, true);
                            break;
                        }
                        returned.whenComplete((? super T next, ? super Throwable ex) -> {
                            if (ex != null) {
                                this.failure((Throwable)ex);
                            } else {
                                this.run(next, currentThread, currentState);
                            }
                        });
                        continue;
                    }
                    this.success(currentValue);
                }
                catch (Throwable ex2) {
                    this.failure(ex2);
                }
                break;
            } while ((currentValue = currentState.take()) != IterationState.END);
        }
        finally {
            currentState.running = false;
        }
    }

    private static final class IterationState<T> {
        static final Object END = new Object();
        boolean running = true;
        private T value = END;

        private IterationState() {
        }

        T take() {
            T result = this.value;
            this.value = END;
            return result;
        }

        void put(T value) {
            this.value = value;
        }
    }
}

