/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.tascalate.concurrent.AbstractCompletableTask;

class CallbackRegistry<T> {
    private final Object mutex = new Object();
    private State<T> state = InitialState.instance();

    CallbackRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <U> void addCallbacks(AbstractCompletableTask<U> target, Function<? super T, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
        Objects.requireNonNull(successCallback, "'successCallback' must not be null");
        Objects.requireNonNull(failureCallback, "'failureCallback' must not be null");
        Objects.requireNonNull(executor, "'executor' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            this.state = this.state.addCallbacks(target, successCallback, failureCallback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean success(T result) {
        State<T> oldState;
        Object object = this.mutex;
        synchronized (object) {
            if (this.state.isCompleted()) {
                return false;
            }
            oldState = this.state;
            this.state = this.state.getSuccessState(result);
        }
        oldState.callSuccessCallbacks(result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean failure(Throwable failure) {
        State<T> oldState;
        Object object = this.mutex;
        synchronized (object) {
            if (this.state.isCompleted()) {
                return false;
            }
            oldState = this.state;
            this.state = this.state.getFailureState(failure);
        }
        oldState.callFailureCallbacks(failure);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFailure() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.isFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleted() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.isCompleted();
        }
    }

    static <T, U> void callCallback(AbstractCompletableTask<U> target, Function<? super T, ? extends U> callback, T value, Executor executor) {
        Callable<Object> callable = () -> callback.apply((Object)value);
        try {
            executor.execute(() -> target.fireTransition(callable));
        }
        catch (RejectedExecutionException ex) {
            Callable<Object> propagateError = () -> {
                throw ex;
            };
            target.fireTransition(propagateError);
        }
    }

    @FunctionalInterface
    static interface AsyncTask
    extends Runnable,
    CompletableFuture.AsynchronousCompletionTask {
    }

    static final class FailureState<S>
    extends State<S> {
        private final Throwable failure;

        FailureState(Throwable failure) {
            this.failure = failure;
        }

        @Override
        protected <U> State<S> addCallbacks(AbstractCompletableTask<U> target, Function<? super S, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
            CallbackRegistry.callCallback(target, failureCallback, this.failure, executor);
            return this;
        }

        @Override
        protected boolean isFailure() {
            return true;
        }
    }

    static final class SuccessState<S>
    extends State<S> {
        private final S result;

        SuccessState(S result) {
            this.result = result;
        }

        @Override
        protected <U> State<S> addCallbacks(AbstractCompletableTask<U> target, Function<? super S, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
            CallbackRegistry.callCallback(target, successCallback, this.result, executor);
            return this;
        }
    }

    static class IntermediateState<S>
    extends State<S> {
        private final Collection<BiConsumer<? super S, ? super Throwable>> callbacks = new LinkedList<BiConsumer<? super S, ? super Throwable>>();

        IntermediateState() {
        }

        @Override
        protected <U> State<S> addCallbacks(AbstractCompletableTask<U> target, Function<? super S, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
            this.callbacks.add((r, e) -> {
                if (null == e) {
                    CallbackRegistry.callCallback(target, successCallback, r, executor);
                } else {
                    CallbackRegistry.callCallback(target, failureCallback, e, executor);
                }
            });
            return this;
        }

        @Override
        protected State<S> getSuccessState(S result) {
            return new SuccessState<S>(result);
        }

        @Override
        protected void callSuccessCallbacks(S result) {
            for (BiConsumer<S, Throwable> callback : this.callbacks) {
                callback.accept(result, null);
            }
        }

        @Override
        protected State<S> getFailureState(Throwable failure) {
            return new FailureState(failure);
        }

        @Override
        protected void callFailureCallbacks(Throwable failure) {
            for (BiConsumer<S, Throwable> callback : this.callbacks) {
                callback.accept(null, failure);
            }
        }

        @Override
        protected boolean isCompleted() {
            return false;
        }
    }

    static class InitialState<S>
    extends State<S> {
        private static final InitialState<Object> instance = new InitialState();

        InitialState() {
        }

        @Override
        protected <U> State<S> addCallbacks(AbstractCompletableTask<U> target, Function<? super S, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
            IntermediateState<? super S> intermediateState = new IntermediateState<S>();
            intermediateState.addCallbacks(target, successCallback, failureCallback, executor);
            return intermediateState;
        }

        @Override
        protected State<S> getSuccessState(S result) {
            return new SuccessState<S>(result);
        }

        @Override
        protected State<S> getFailureState(Throwable failure) {
            return new FailureState(failure);
        }

        @Override
        protected boolean isCompleted() {
            return false;
        }

        static <T> State<T> instance() {
            return instance;
        }
    }

    static abstract class State<S> {
        State() {
        }

        protected abstract <U> State<S> addCallbacks(AbstractCompletableTask<U> var1, Function<? super S, ? extends U> var2, Function<Throwable, ? extends U> var3, Executor var4);

        protected State<S> getSuccessState(S result) {
            throw new IllegalStateException("success method should not be called multiple times");
        }

        protected void callSuccessCallbacks(S result) {
        }

        protected State<S> getFailureState(Throwable failure) {
            throw new IllegalStateException("failure method should not be called multiple times");
        }

        protected void callFailureCallbacks(Throwable failure) {
        }

        protected boolean isCompleted() {
            return true;
        }

        protected boolean isFailure() {
            return false;
        }
    }
}

