/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.CompletableTask;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.core.CompletionStageAPI;
import net.tascalate.concurrent.decorators.AbstractCompletionStageDecorator;

public class CompletablePromise<T>
extends CompletableFutureWrapper<T> {
    public CompletablePromise() {
        this(new CompletableFuture());
    }

    public CompletablePromise(CompletableFuture<T> delegate) {
        super(delegate);
    }

    public boolean complete(T value) {
        return this.success(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.failure(ex);
    }

    @Override
    public boolean complete(T value, Throwable ex) {
        return super.complete(value, ex);
    }

    public Promise<T> completeAsync(Supplier<? extends T> supplier) {
        CompletionStageAPI api = CompletionStageAPI.current();
        Promise<T> result = this.completeAsync(supplier, api.defaultExecutorOf((CompletableFuture)this.delegate));
        if (api.defaultExecutorOverridable() || ((CompletableFuture)this.delegate).getClass() == CompletableFuture.class) {
            return result;
        }
        return result.dependent().thenApplyAsync(Function.identity(), true).unwrap();
    }

    public Promise<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        Promise<Object> result = CompletableTask.submit(supplier::get, executor);
        result.whenComplete((r, e) -> {
            if (!result.isCancelled()) {
                this.complete(r, SharedFunctions.unwrapCompletionException(e));
            }
        });
        return result;
    }

    public CompletablePromise<T> copy() {
        Promise result = this.wrapNew((CompletionStage)new CompletableFuture());
        if (this.isDone()) {
            try {
                ((CompletablePromise)result).complete(this.join());
            }
            catch (CompletionException ex) {
                ((CompletablePromise)result).completeExceptionally(ex);
            }
            catch (Throwable ex) {
                ((CompletablePromise)result).completeExceptionally(SharedFunctions.wrapCompletionException(ex));
            }
            return result;
        }
        this.whenComplete(((CompletablePromise)result)::complete);
        return result;
    }

    public Promise<T> minimalPromise() {
        CompletableFutureWrapper result = new CompletableFutureWrapper();
        if (this.isDone()) {
            try {
                result.success(this.join());
            }
            catch (CompletionException ex) {
                result.failure(ex);
            }
            catch (Throwable ex) {
                result.failure(SharedFunctions.wrapCompletionException(ex));
            }
            return result;
        }
        this.whenComplete(result::complete);
        return result;
    }

    public CompletionStage<T> minimalCompletionStage() {
        return new MinimalCompletionStage(this);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return (CompletableFuture)this.delegate;
    }

    @Override
    public CompletionStage<T> \u03b1() {
        return this.delegate;
    }

    @Override
    protected <U> CompletablePromise<U> wrapNew(CompletionStage<U> original) {
        return new CompletablePromise<T>((CompletableFuture)original);
    }

    static class MinimalCompletionStage<T>
    extends AbstractCompletionStageDecorator<T, CompletionStage<T>> {
        public MinimalCompletionStage(CompletionStage<T> delegate) {
            super(delegate);
        }

        @Override
        protected <U> CompletionStage<U> wrapNew(CompletionStage<U> original) {
            return new MinimalCompletionStage<U>(original);
        }

        @Override
        public CompletableFuture<T> toCompletableFuture() {
            CompletableFuture result = new CompletableFuture();
            this.whenComplete((r, e) -> SharedFunctions.iif(null == e ? result.complete(r) : result.completeExceptionally((Throwable)e)));
            return result;
        }
    }
}

