/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import net.tascalate.concurrent.AbstractCompletableTask;

class CompletableSubTask<T>
extends AbstractCompletableTask<T> {
    private final DelegatingCallable<T> action;

    CompletableSubTask(Executor executor) {
        this(executor, new DelegatingCallable());
    }

    private CompletableSubTask(Executor executor, DelegatingCallable<T> action) {
        super(executor, action);
        this.action = action;
    }

    @Override
    final void fireTransition(Callable<T> code) {
        this.action.setup(code);
        this.task.run();
    }

    @Override
    protected <U> AbstractCompletableTask<U> createCompletionStage(Executor executor) {
        return new CompletableSubTask<T>(executor);
    }

    private static class DelegatingCallable<T>
    implements Callable<T> {
        private final AtomicReference<Callable<T>> delegateRef = new AtomicReference();

        private DelegatingCallable() {
        }

        void setup(Callable<T> delegate) {
            boolean updated = this.delegateRef.compareAndSet(null, delegate);
            if (!updated) {
                throw new IllegalStateException("Delegate may be set only once");
            }
        }

        @Override
        public T call() throws Exception {
            Callable<T> delegate = this.delegateRef.get();
            if (null == delegate) {
                throw new IllegalStateException("Call is not configured");
            }
            return delegate.call();
        }
    }
}

