/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.tascalate.concurrent.AbstractCompletableTask;
import net.tascalate.concurrent.CompletableSubTask;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.decorators.ExecutorBoundPromise;

public class CompletableTask<T>
extends AbstractCompletableTask<T> {
    protected CompletableTask(Executor executor, Callable<T> callable) {
        super(executor, callable);
    }

    public static <T> Promise<T> completed(T value, Executor defaultExecutor) {
        CompletableTask<Object> result = new CompletableTask<Object>(defaultExecutor, () -> value);
        SAME_THREAD_EXECUTOR.execute(result.task);
        return result;
    }

    public static Promise<Void> asyncOn(Executor executor) {
        return CompletableTask.completed(null, executor);
    }

    public static Promise<Void> asyncOn(Executor executor, boolean enforceDefaultAsync) {
        Promise<Object> result = CompletableTask.completed(null, executor);
        if (enforceDefaultAsync) {
            class EnforcedExecutorBoundPromise<T>
            extends ExecutorBoundPromise<T> {
                final /* synthetic */ Executor val$executor;

                public EnforcedExecutorBoundPromise(Promise<T> promise) {
                    this.val$executor = promise;
                    super(delegate, (Executor)((Object)promise));
                }

                @Override
                protected <U> Promise<U> wrapNew(CompletionStage<U> original) {
                    return new EnforcedExecutorBoundPromise((Promise)original, this.val$executor);
                }

                @Override
                public Promise<T> unwrap() {
                    return this;
                }

                @Override
                public Promise<T> raw() {
                    return this;
                }
            }
            return new EnforcedExecutorBoundPromise(result, executor);
        }
        return result;
    }

    public static Promise<Void> runAsync(Runnable runnable, Executor executor) {
        return CompletableTask.submit(() -> {
            runnable.run();
            return null;
        }, executor);
    }

    public static <U> Promise<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return CompletableTask.submit(supplier::get, executor);
    }

    public static <U> Promise<U> submit(Callable<U> call, Executor executor) {
        CompletableTask<U> result = new CompletableTask<U>(executor, call);
        executor.execute(result.task);
        return result;
    }

    public static <T> Promise<T> waitFor(CompletionStage<T> stage, Executor executor) {
        return CompletableTask.waitFor(stage, executor, false);
    }

    public static <T> Promise<T> waitFor(CompletionStage<T> stage, Executor executor, boolean dependentStage) {
        return CompletableTask.asyncOn(executor).dependent().thenCombine(stage, SharedFunctions.selectSecond(), CompletableTask.enlistParamOrNone(dependentStage)).unwrap();
    }

    public static Promise<Duration> delay(long timeout, TimeUnit unit, Executor executor) {
        return CompletableTask.delay(Timeouts.toDuration(timeout, unit), executor);
    }

    public static Promise<Duration> delay(Duration duration, Executor executor) {
        return CompletableTask.asyncOn(executor).dependent().thenCombineAsync(Timeouts.delay(duration), SharedFunctions.selectSecond(), CompletableTask.enlistParamOrNone(true)).unwrap();
    }

    protected void runTask() {
        this.task.run();
    }

    @Override
    void fireTransition(Callable<T> code) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected <U> AbstractCompletableTask<U> createCompletionStage(Executor executor) {
        return new CompletableSubTask(executor);
    }

    private static Set<PromiseOrigin> enlistParamOrNone(boolean enlistParam) {
        return enlistParam ? PromiseOrigin.PARAM_ONLY : PromiseOrigin.NONE;
    }
}

