/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.tascalate.concurrent.CompletionStageRef;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseHelper;
import net.tascalate.concurrent.Promises;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.decorators.AbstractPromiseDecorator;
import net.tascalate.concurrent.decorators.AbstractPromiseLikeDecorator;
import net.tascalate.concurrent.decorators.BlockingCompletionStageDecorator;

public class CompletionStageWrapper<T>
extends AbstractPromiseLikeDecorator<T, CompletionStage<T>>
implements Promise<T> {
    private final CountDownLatch whenDone = new CountDownLatch(1);
    private volatile T result = null;
    private volatile Throwable fault = null;

    protected CompletionStageWrapper(CompletionStage<T> delegate) {
        super(delegate);
        delegate.whenComplete((? super T r, ? super Throwable e) -> {
            this.result = r;
            this.fault = e;
            this.whenDone.countDown();
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return SharedFunctions.cancelPromise(this.delegate, mayInterruptIfRunning);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.whenDone.await();
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(this.fault));
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.whenDone.await(timeout, unit);
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(this.fault));
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.isDone() && this.fault != null;
    }

    @Override
    public boolean isCancelled() {
        return this.isDone() && this.fault instanceof CancellationException;
    }

    @Override
    public boolean isDone() {
        return this.whenDone.getCount() == 0L;
    }

    @Override
    public T join() {
        try {
            this.whenDone.await();
        }
        catch (InterruptedException ex) {
            throw new CompletionException(ex);
        }
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapCompletionException(this.fault);
    }

    @Override
    protected final <U> Promise<U> wrapNew(CompletionStage<U> original) {
        return Promises.from(original);
    }

    public static <T> Promise<T> from(CompletionStage<T> stage) {
        return CompletionStageWrapper.from(stage, true);
    }

    public static <T> Promise<T> from(CompletionStage<T> stage, boolean strictPromise) {
        AbstractPromiseLikeDecorator result = stage instanceof Future ? BlockingCompletionStageDecorator.from(stage) : new CompletionStageWrapper<T>(stage);
        return strictPromise ? new StrictPromise(result) : result;
    }

    static class StrictPromise<T>
    extends AbstractPromiseDecorator<T, Promise<T>> {
        StrictPromise(Promise<T> delegate) {
            super(delegate);
        }

        @Override
        public Promise<T> unwrap() {
            return this;
        }

        @Override
        public Promise<T> raw() {
            return this;
        }

        @Override
        protected <U> Promise<U> wrapNew(CompletionStage<U> original) {
            return new StrictPromise<T>((Promise)original);
        }

        @Override
        public <U> Promise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
            CompletionStageRef ref = new CompletionStageRef();
            return super.thenCompose((Function)ref.captureResult(fn)).onCancel(ref.cancel);
        }

        @Override
        public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
            CompletionStageRef ref = new CompletionStageRef();
            return super.thenComposeAsync((Function)ref.captureResult(fn)).onCancel(ref.cancel);
        }

        @Override
        public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
            CompletionStageRef ref = new CompletionStageRef();
            return super.thenComposeAsync((Function)ref.captureResult(fn), executor).onCancel(ref.cancel);
        }

        @Override
        public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
            return PromiseHelper.exceptionallyAsync(this, fn);
        }

        @Override
        public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
            return PromiseHelper.exceptionallyAsync(this, fn, executor);
        }

        @Override
        public Promise<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
            return PromiseHelper.exceptionallyCompose(this, fn);
        }

        @Override
        public Promise<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
            return PromiseHelper.exceptionallyComposeAsync(this, fn);
        }

        @Override
        public Promise<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
            return PromiseHelper.exceptionallyComposeAsync(this, fn, executor);
        }
    }
}

