/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.delays.BoundedMaxDelayPolicy;
import net.tascalate.concurrent.delays.BoundedMinDelayPolicy;
import net.tascalate.concurrent.delays.ExponentialDelayPolicy;
import net.tascalate.concurrent.delays.FirstRetryNoDelayPolicy;
import net.tascalate.concurrent.delays.FixedIntervalDelayPolicy;
import net.tascalate.concurrent.delays.OnFailureNoDelayPolicy;
import net.tascalate.concurrent.delays.OnSuccessNoDelayPolicy;
import net.tascalate.concurrent.delays.ProportionalRandomDelayPolicy;
import net.tascalate.concurrent.delays.UniformRandomDelayPolicy;

public interface DelayPolicy<T> {
    public static final DelayPolicy<Object> DEFAULT = new FirstRetryNoDelayPolicy<Object>(new FixedIntervalDelayPolicy());
    public static final DelayPolicy<Object> INVALID = ctx -> Timeouts.NEGATIVE_DURATION;

    public Duration delay(RetryContext<? extends T> var1);

    public static <T> DelayPolicy<T> fixedInterval() {
        return new FixedIntervalDelayPolicy();
    }

    public static <T> DelayPolicy<T> fixedInterval(Duration interval) {
        return new FixedIntervalDelayPolicy(interval);
    }

    public static <T> DelayPolicy<T> fixedInterval(long interval, TimeUnit timeUnit) {
        return DelayPolicy.fixedInterval(Timeouts.toDuration(interval, timeUnit));
    }

    public static <T> DelayPolicy<T> fixedInterval(long intervalMillis) {
        return DelayPolicy.fixedInterval(Duration.ofMillis(intervalMillis));
    }

    public static <T> DelayPolicy<T> exponential(double multiplier) {
        return new ExponentialDelayPolicy(multiplier);
    }

    public static <T> DelayPolicy<T> exponential(Duration initialDelay, double multiplier) {
        return new ExponentialDelayPolicy(initialDelay, multiplier);
    }

    public static <T> DelayPolicy<T> exponential(long initialDelay, TimeUnit timeUnit, double multiplier) {
        return DelayPolicy.exponential(Timeouts.toDuration(initialDelay, timeUnit), multiplier);
    }

    public static <T> DelayPolicy<T> exponential(long initialDelayMillis, double multiplier) {
        return DelayPolicy.exponential(Duration.ofMillis(initialDelayMillis), multiplier);
    }

    default public DelayPolicy<T> withUniformJitter() {
        return new UniformRandomDelayPolicy(this);
    }

    default public DelayPolicy<T> withUniformJitter(long range) {
        return this.withUniformJitter(range, TimeUnit.MILLISECONDS);
    }

    default public DelayPolicy<T> withUniformJitter(long range, TimeUnit timeUnit) {
        return this.withUniformJitter(Timeouts.toDuration(range, timeUnit));
    }

    default public DelayPolicy<T> withUniformJitter(Duration range) {
        return new UniformRandomDelayPolicy(this, range);
    }

    default public DelayPolicy<T> withProportionalJitter() {
        return new ProportionalRandomDelayPolicy(this);
    }

    default public DelayPolicy<T> withProportionalJitter(double multiplier) {
        return new ProportionalRandomDelayPolicy(this, multiplier);
    }

    default public DelayPolicy<T> withMinDelay() {
        return new BoundedMinDelayPolicy(this);
    }

    default public DelayPolicy<T> withMinDelay(Duration minDelay) {
        return new BoundedMinDelayPolicy(this, minDelay);
    }

    default public DelayPolicy<T> withMinDelay(long minDelay, TimeUnit timeUnit) {
        return this.withMinDelay(Timeouts.toDuration(minDelay, timeUnit));
    }

    default public DelayPolicy<T> withMinDelay(long minDelayMillis) {
        return this.withMinDelay(Duration.ofMillis(minDelayMillis));
    }

    default public DelayPolicy<T> withMaxDelay() {
        return new BoundedMaxDelayPolicy(this);
    }

    default public DelayPolicy<T> withMaxDelay(Duration maxDelay) {
        return new BoundedMaxDelayPolicy(this, maxDelay);
    }

    default public DelayPolicy<T> withMaxDelay(long maxDelay, TimeUnit timeUnit) {
        return this.withMaxDelay(Timeouts.toDuration(maxDelay, timeUnit));
    }

    default public DelayPolicy<T> withMaxDelay(long maxDelayMillis) {
        return this.withMaxDelay(Duration.ofMillis(maxDelayMillis));
    }

    default public DelayPolicy<T> withFirstRetryNoDelay() {
        return new FirstRetryNoDelayPolicy(this);
    }

    default public DelayPolicy<T> withOnFailureNoDelay() {
        return new OnFailureNoDelayPolicy(this);
    }

    default public DelayPolicy<T> withOnSuccessNoDelay() {
        return new OnSuccessNoDelayPolicy(this);
    }

    default public <D extends DelayPolicy<T>> D withCusomizer(Function<? super DelayPolicy<T>, D> fn) {
        return (D)((DelayPolicy)fn.apply(this));
    }

    public static boolean isValid(Duration d) {
        return !d.isNegative() && !d.isZero();
    }
}

