/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tascalate.concurrent.PaddedOutputStream;
import net.tascalate.concurrent.PaddedWriter;

public class MultitargetException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final List<Throwable> exceptions;
    private static final String NEW_LINE = System.lineSeparator();

    public MultitargetException(String message, List<Throwable> exceptions) {
        super(message);
        this.exceptions = exceptions == null ? Collections.emptyList() : Collections.unmodifiableList(exceptions);
        List causes = this.exceptions.stream().filter(Objects::nonNull).collect(Collectors.toList());
        switch (causes.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.initCause((Throwable)causes.get(0));
                break;
            }
            default: {
                for (Throwable cause : causes) {
                    this.addSuppressed(cause);
                }
            }
        }
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    Optional<Throwable> getFirstException() {
        return this.exceptions.stream().filter(Objects::nonNull).findFirst();
    }

    public void printExceptions() {
        this.printExceptions(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printExceptions(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            this.printExceptions(s, MultitargetException.newDejavueSet());
        }
    }

    void printExceptions(PrintStream s, Set<Throwable> visited) {
        visited.add(this);
        s.println(this);
        for (StackTraceElement trace : this.getStackTrace()) {
            s.println("\tat " + trace);
        }
        this.printExceptions(s, (Throwable ex, String padding) -> {
            PrintStream ps = new PrintStream(new PaddedOutputStream(s, (String)padding));
            if (visited.contains(ex)) {
                ps.println("\t[CIRCULAR REFERENCE:" + ex + "]");
            } else if (ex instanceof MultitargetException) {
                ((MultitargetException)ex).printExceptions(ps, visited);
            } else {
                ex.printStackTrace(ps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printExceptions(PrintWriter w) {
        PrintWriter printWriter = w;
        synchronized (printWriter) {
            this.printExceptions(w, MultitargetException.newDejavueSet());
        }
    }

    void printExceptions(PrintWriter w, Set<Throwable> visited) {
        visited.add(this);
        w.println(this);
        for (StackTraceElement trace : this.getStackTrace()) {
            w.println("\tat " + trace);
        }
        this.printExceptions(w, (Throwable ex, String padding) -> {
            PrintWriter pw = new PrintWriter((Writer)new PaddedWriter(w, (String)padding), true);
            if (visited.contains(ex)) {
                pw.println("\t[CIRCULAR REFERENCE:" + ex + "]");
            } else if (ex instanceof MultitargetException) {
                ((MultitargetException)ex).printExceptions(pw, visited);
            } else {
                ex.printStackTrace(pw);
            }
        });
    }

    private <O extends Appendable> void printExceptions(O out, BiConsumer<Throwable, String> nestedExceptionPrinter) {
        int idx = 0;
        int n = (int)Math.log10(this.exceptions.size()) + 1;
        String idxPadder = "%0" + n + "d";
        String padding = String.format("\t %1$-" + n + "s  ... ", "");
        Consumer<Throwable> printer = ex -> nestedExceptionPrinter.accept((Throwable)ex, padding);
        for (Throwable e : this.exceptions) {
            if (null == e) {
                ++idx;
                continue;
            }
            try {
                MultitargetException.printException(String.format(idxPadder, idx++), e, out, printer);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    private static <O extends Appendable> void printException(String idx, Throwable ex, O out, Consumer<Throwable> nestedExceptionPrinter) throws IOException {
        out.append("\t[");
        out.append(idx);
        out.append("] -> ");
        if (null == ex) {
            out.append("<NO ERROR>");
            out.append(NEW_LINE);
        } else {
            nestedExceptionPrinter.accept(ex);
        }
    }

    private static <T> Set<T> newDejavueSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }
}

