/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.io.IOException;
import java.io.Writer;

class PaddedWriter
extends Writer {
    private final Writer delegate;
    private final char[] padding;
    private volatile boolean needPadding = false;

    public PaddedWriter(Writer delegate, String padding) {
        this.delegate = delegate;
        this.padding = padding.toCharArray();
    }

    private void writePaddingIfNecessary() throws IOException {
        if (this.needPadding) {
            this.delegate.write(this.padding);
            this.needPadding = false;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b != 13 && b != 10) {
            this.writePaddingIfNecessary();
        }
        if (b == 13 || b == 10) {
            this.needPadding = true;
        }
        this.delegate.write(b);
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        this.writePaddingIfNecessary();
        int from = off;
        boolean needPadding = false;
        for (int idx = off; idx < len; ++idx) {
            if (b[idx] == '\r' || b[idx] == '\n') {
                needPadding = true;
                continue;
            }
            if (!needPadding) continue;
            if (from < idx) {
                this.delegate.write(b, from, idx - from + 1);
            }
            this.delegate.write(this.padding);
            needPadding = false;
            from = idx + 1;
        }
        if (from < len) {
            this.delegate.write(b, from, len);
        }
        this.needPadding = needPadding;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        try (Writer writer = this.delegate;){
            this.flush();
        }
    }
}

