/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.tascalate.concurrent.ConfigurableDependentPromise;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.PromiseHelper;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.Try;
import net.tascalate.concurrent.decorators.ExecutorBoundPromise;

public interface Promise<T>
extends Future<T>,
CompletionStage<T> {
    default public T getNow(T valueIfAbsent) throws CancellationException, CompletionException {
        return this.getNow(SharedFunctions.supply(valueIfAbsent));
    }

    default public T getNow(Supplier<? extends T> valueIfAbsent) throws CancellationException, CompletionException {
        if (this.isDone()) {
            try {
                return (T)this.get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw SharedFunctions.wrapCompletionException(SharedFunctions.unwrapExecutionException(ex));
            }
        }
        return valueIfAbsent.get();
    }

    default public T join() throws CancellationException, CompletionException {
        try {
            return (T)this.get();
        }
        catch (InterruptedException ex) {
            throw new CompletionException(ex);
        }
        catch (ExecutionException ex) {
            throw SharedFunctions.wrapCompletionException(SharedFunctions.unwrapExecutionException(ex));
        }
    }

    default public boolean isCompletedExceptionally() {
        if (!this.isDone()) {
            return false;
        }
        if (this.isCancelled()) {
            return true;
        }
        try {
            this.get();
        }
        catch (Throwable ex) {
            return true;
        }
        return false;
    }

    default public Promise<T> onCancel(Runnable action) {
        if (this.isDone()) {
            if (this.isCancelled()) {
                action.run();
            }
        } else {
            this.exceptionally((T __) -> {
                if (this.isCancelled()) {
                    action.run();
                }
                return null;
            });
        }
        return this;
    }

    default public Promise<T> delay(long timeout, TimeUnit unit) {
        return this.delay(timeout, unit, true);
    }

    default public Promise<T> delay(long timeout, TimeUnit unit, boolean delayOnError) {
        return this.delay(Timeouts.toDuration(timeout, unit), delayOnError);
    }

    default public Promise<T> delay(Duration duration) {
        return this.delay(duration, true);
    }

    default public Promise<T> delay(Duration duration, boolean delayOnError) {
        if (!delayOnError) {
            return this.thenCompose((T v) -> this.dependent().thenCombineAsync(Timeouts.delay(duration), SharedFunctions.selectFirst(), PromiseOrigin.PARAM_ONLY).unwrap());
        }
        DependentPromise<Try> h = this.dependent().handle((r, e) -> Try.handle(r, e, null), false);
        return h.thenCompose(t -> t.isSuccess() || !this.isCancelled() && !t.isCancel() ? h.thenCombineAsync(Timeouts.delay(duration), (? super T _1, ? super U _2) -> this.join(), PromiseOrigin.PARAM_ONLY) : this, true).unwrap();
    }

    default public Promise<T> orTimeout(long timeout, TimeUnit unit) {
        return this.orTimeout(timeout, unit, true);
    }

    default public Promise<T> orTimeout(long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.orTimeout(Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> orTimeout(Duration duration) {
        return this.orTimeout(duration, true);
    }

    default public Promise<T> orTimeout(Duration duration, boolean cancelOnTimeout) {
        Promise<Object> onTimeout = Timeouts.delayed(null, duration);
        return this.dependent().handle((r, e) -> Try.handle(r, e, onTimeout), false).applyToEither(onTimeout, SharedFunctions.applyAndCancel(v -> Try.doneOrTimeout(v, duration), cancelOnTimeout, this), PromiseOrigin.ALL).thenComposeAsync(Try::asPromise, true).unwrap();
    }

    default public Promise<T> onTimeout(T value, long timeout, TimeUnit unit) {
        return this.onTimeout(value, timeout, unit, true);
    }

    default public Promise<T> onTimeout(T value, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout(value, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> onTimeout(T value, Duration duration) {
        return this.onTimeout(value, duration, true);
    }

    default public Promise<T> onTimeout(T value, Duration duration, boolean cancelOnTimeout) {
        Promise onTimeout = Timeouts.delayed(Try.success(value), duration);
        return this.dependent().handle((r, e) -> Try.handle(r, e, onTimeout), false).applyToEither(onTimeout, SharedFunctions.applyAndCancel(Function.identity(), cancelOnTimeout, this), PromiseOrigin.ALL).thenComposeAsync(Try::asPromise, true).unwrap();
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit) {
        return this.onTimeout(supplier, timeout, unit, true);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout(supplier, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, Duration duration) {
        return this.onTimeout(supplier, duration, true);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, Duration duration, boolean cancelOnTimeout) {
        Promise onTimeout = Timeouts.delayed(Try.call(supplier), duration);
        return this.dependent().handle((r, e) -> SharedFunctions.supply(Try.handle(r, e, onTimeout)), false).applyToEither(onTimeout, SharedFunctions.applyAndCancel(Function.identity(), cancelOnTimeout, this), PromiseOrigin.ALL).thenComposeAsync((? super T s) -> ((Try)s.get()).asPromise(), true).unwrap();
    }

    default public DependentPromise<T> dependent() {
        return ConfigurableDependentPromise.from(this);
    }

    default public DependentPromise<T> dependent(Set<PromiseOrigin> defaultEnlistOptions) {
        return ConfigurableDependentPromise.from(this, defaultEnlistOptions);
    }

    default public Promise<T> defaultAsyncOn(Executor executor) {
        return new ExecutorBoundPromise(this, executor);
    }

    default public <D> D as(Function<? super Promise<T>, D> decoratorFactory) {
        return decoratorFactory.apply(this);
    }

    default public Promise<T> unwrap() {
        return this;
    }

    default public Promise<T> raw() {
        return this;
    }

    @Override
    public <U> Promise<U> thenApply(Function<? super T, ? extends U> var1);

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> var1);

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> var1, Executor var2);

    public Promise<Void> thenAccept(Consumer<? super T> var1);

    public Promise<Void> thenAcceptAsync(Consumer<? super T> var1);

    public Promise<Void> thenAcceptAsync(Consumer<? super T> var1, Executor var2);

    public Promise<Void> thenRun(Runnable var1);

    public Promise<Void> thenRunAsync(Runnable var1);

    public Promise<Void> thenRunAsync(Runnable var1, Executor var2);

    @Override
    public <U, V> Promise<V> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Executor var3);

    public <U> Promise<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Executor var3);

    public Promise<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> Promise<U> applyToEither(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Executor var3);

    public Promise<Void> acceptEither(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Executor var3);

    public Promise<Void> runAfterEither(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> Promise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, Executor var2);

    @Override
    public Promise<T> exceptionally(Function<Throwable, ? extends T> var1);

    @Override
    default public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
        return PromiseHelper.exceptionallyAsync(this, fn);
    }

    @Override
    default public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return PromiseHelper.exceptionallyAsync(this, fn, executor);
    }

    @Override
    default public Promise<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return PromiseHelper.exceptionallyCompose(this, fn);
    }

    @Override
    default public Promise<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return PromiseHelper.exceptionallyComposeAsync(this, fn);
    }

    @Override
    default public Promise<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return PromiseHelper.exceptionallyComposeAsync(this, fn, executor);
    }

    default public Promise<T> thenFilter(Predicate<? super T> predicate) {
        return this.thenFilter(predicate, SharedFunctions.NO_SUCH_ELEMENT);
    }

    default public Promise<T> thenFilter(Predicate<? super T> predicate, Function<? super T, Throwable> errorSupplier) {
        return this.thenCompose((T v) -> predicate.test(v) ? this : SharedFunctions.failure(errorSupplier, v));
    }

    default public Promise<T> thenFilterAsync(Predicate<? super T> predicate) {
        return this.thenFilterAsync(predicate, SharedFunctions.NO_SUCH_ELEMENT);
    }

    default public Promise<T> thenFilterAsync(Predicate<? super T> predicate, Function<? super T, Throwable> errorSupplier) {
        return this.thenComposeAsync((T v) -> predicate.test(v) ? this : SharedFunctions.failure(errorSupplier, v));
    }

    default public Promise<T> thenFilterAsync(Predicate<? super T> predicate, Executor executor) {
        return this.thenFilterAsync(predicate, SharedFunctions.NO_SUCH_ELEMENT, executor);
    }

    default public Promise<T> thenFilterAsync(Predicate<? super T> predicate, Function<? super T, Throwable> errorSupplier, Executor executor) {
        return this.thenComposeAsync((T v) -> predicate.test(v) ? this : SharedFunctions.failure(errorSupplier, v), executor);
    }

    @Override
    public Promise<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, Executor var2);

    @Override
    public <U> Promise<U> handle(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, Executor var2);
}

