/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseAdapter;
import net.tascalate.concurrent.SharedFunctions;

abstract class PromiseAdapterExtended<T>
extends PromiseAdapter<T> {
    private static final Function<Throwable, Object> FORWARD_EXCEPTION = PromiseAdapterExtended::forwardException;

    protected PromiseAdapterExtended(Executor defaultExecutor) {
        super(defaultExecutor);
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.handleAsync((T r, U e) -> null == e ? fn.apply(r) : PromiseAdapterExtended.forwardException(e), executor);
    }

    @Override
    public Promise<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.handleAsync((T r, U e) -> null == e ? r : fn.apply((Throwable)e), executor);
    }

    @Override
    public Promise<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.thenApplyAsync(PromiseAdapterExtended.consumerAsFunction(action), executor);
    }

    @Override
    public Promise<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenApplyAsync(PromiseAdapterExtended.runnableAsFunction(action), executor);
    }

    @Override
    public Promise<T> thenFilterAsync(Predicate<? super T> predicate, Function<? super T, Throwable> errorSupplier, Executor executor) {
        return this.handleAsync((T r, U e) -> null == e ? (predicate.test(r) ? r : PromiseAdapterExtended.forwardException((Throwable)errorSupplier.apply(r))) : PromiseAdapterExtended.forwardException(e), executor);
    }

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.thenCompose((T result1) -> other.thenApplyAsync((? super T result2) -> fn.apply(result1, result2), executor));
    }

    @Override
    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.thenCombineAsync((CompletionStage)other, (T t, U u) -> {
            action.accept(t, u);
            return null;
        }, executor);
    }

    @Override
    public Promise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.thenCombineAsync(other, (T t, U r) -> {
            action.run();
            return null;
        }, executor);
    }

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.doApplyToEitherAsync(this, other, fn, executor);
    }

    @Override
    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.applyToEitherAsync((CompletionStage)other, PromiseAdapterExtended.consumerAsFunction(action), executor);
    }

    @Override
    public Promise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.doApplyToEitherAsync(this, other, PromiseAdapterExtended.runnableAsFunction(action), executor);
    }

    protected abstract <R, U> Promise<U> doApplyToEitherAsync(CompletionStage<? extends R> var1, CompletionStage<? extends R> var2, Function<? super R, U> var3, Executor var4);

    protected static <U> U forwardException(Throwable e) {
        throw SharedFunctions.wrapCompletionException(e);
    }

    protected static <U> Function<Throwable, U> forwardException() {
        return FORWARD_EXCEPTION;
    }

    protected static <V, R> Function<V, R> consumerAsFunction(Consumer<? super V> action) {
        return result -> {
            action.accept((Object)result);
            return null;
        };
    }

    private static <R> Function<R, Void> runnableAsFunction(Runnable action) {
        return result -> {
            action.run();
            return null;
        };
    }
}

