/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.Promise;

class PromiseHelper {
    private PromiseHelper() {
    }

    static <T> Promise<T> exceptionallyAsync(Promise<T> p, Function<Throwable, ? extends T> fn) {
        DependentPromise<Either> h = p.dependent().handle(Either::lift, false);
        return h.thenCompose(e -> e.isLeft() ? p : h.thenApplyAsync(in -> fn.apply((Throwable)in.right())), true).unwrap();
    }

    static <T> Promise<T> exceptionallyAsync(Promise<T> p, Function<Throwable, ? extends T> fn, Executor executor) {
        DependentPromise<Either> h = p.dependent().handle(Either::lift, false);
        return h.thenCompose(e -> e.isLeft() ? p : h.thenApplyAsync(in -> fn.apply((Throwable)in.right()), executor), true).unwrap();
    }

    static <T> Promise<T> exceptionallyCompose(Promise<T> p, Function<Throwable, ? extends CompletionStage<T>> fn) {
        DependentPromise<Either> h = p.dependent().handle(Either::lift, false);
        return h.thenCompose(e -> e.isLeft() ? p : (CompletionStage)fn.apply((Throwable)e.right()), true).unwrap();
    }

    static <T> Promise<T> exceptionallyComposeAsync(Promise<T> p, Function<Throwable, ? extends CompletionStage<T>> fn) {
        DependentPromise<Either> h = p.dependent().handle(Either::lift, false);
        return h.thenCompose(e -> e.isLeft() ? p : h.thenComposeAsync(in -> (CompletionStage)fn.apply((Throwable)in.right())), true).unwrap();
    }

    static <T> Promise<T> exceptionallyComposeAsync(Promise<T> p, Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        DependentPromise<Either> h = p.dependent().handle(Either::lift, false);
        return h.thenCompose(e -> e.isLeft() ? p : h.thenComposeAsync(in -> (CompletionStage)fn.apply((Throwable)in.right()), executor), true).unwrap();
    }

    static abstract class Either<A, B> {
        Either() {
        }

        A left() {
            throw new UnsupportedOperationException();
        }

        B right() {
            throw new UnsupportedOperationException();
        }

        abstract boolean isLeft();

        static <A, B> Either<A, B> lift(final A a, final B b) {
            if (null == b) {
                return new Either<A, B>(){

                    @Override
                    A left() {
                        return a;
                    }

                    @Override
                    boolean isLeft() {
                        return true;
                    }
                };
            }
            return new Either<A, B>(){

                @Override
                B right() {
                    return b;
                }

                @Override
                boolean isLeft() {
                    return false;
                }
            };
        }
    }
}

