/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tascalate.concurrent.AggregatingPromise;
import net.tascalate.concurrent.AsyncCloseable;
import net.tascalate.concurrent.AsyncLoop;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.CompletableTask;
import net.tascalate.concurrent.CompletionStageWrapper;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.MultitargetException;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.RetryCallable;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.RetryPolicy;
import net.tascalate.concurrent.RetryRunnable;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;

public final class Promises {
    private Promises() {
    }

    public static <T> Promise<T> success(T value) {
        return new CompletableFutureWrapper<T>(CompletableFuture.completedFuture(value));
    }

    public static <T> Promise<T> failure(Throwable exception) {
        CompletableFuture delegate = new CompletableFuture();
        delegate.completeExceptionally(exception);
        return new CompletableFutureWrapper(delegate);
    }

    public static <T> Promise<T> maybe(Optional<T> maybeValue) {
        return maybeValue.map(Promises::success).orElseGet(() -> Promises.failure(new NoSuchElementException()));
    }

    public static <T> Promise<T> from(CompletionStage<T> stage) {
        if (stage instanceof Promise) {
            return (Promise)stage;
        }
        if (stage instanceof CompletableFuture) {
            return new CompletableFutureWrapper((CompletableFuture)stage);
        }
        return CompletionStageWrapper.from(stage);
    }

    public static Throwable unwrapCompletionException(Throwable ex) {
        return SharedFunctions.unwrapCompletionException(ex);
    }

    public static <T> Promise<T> loop(T initialValue, Predicate<? super T> loopCondition, Function<? super T, ? extends CompletionStage<T>> loopBody) {
        AsyncLoop<T> asyncLoop = new AsyncLoop<T>(loopCondition, loopBody);
        asyncLoop.run(initialValue);
        return asyncLoop;
    }

    public static <T, R extends AutoCloseable> Promise<T> tryApply(CompletionStage<R> stage, Function<? super R, ? extends T> fn) {
        return Promises.tryApply(Promises.from(stage), fn);
    }

    public static <T, R extends AutoCloseable> Promise<T> tryApply(Promise<R> p, Function<? super R, ? extends T> fn) {
        return p.thenApply(r -> {
            Object r2;
            block9: {
                AutoCloseable resource = r;
                try {
                    r2 = fn.apply((Object)resource);
                    if (resource == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resource != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException rte) {
                        throw rte;
                    }
                    catch (Throwable ex) {
                        throw new CompletionException(ex);
                    }
                }
                resource.close();
            }
            return r2;
        });
    }

    public static <T, R extends AsyncCloseable> Promise<T> tryApplyEx(CompletionStage<R> stage, Function<? super R, ? extends T> fn) {
        return Promises.tryApplyEx(Promises.from(stage), fn);
    }

    public static <T, R extends AsyncCloseable> Promise<T> tryApplyEx(Promise<R> p, Function<? super R, ? extends T> fn) {
        return p.thenCompose(resource -> {
            Object result;
            try {
                result = fn.apply((Object)resource);
            }
            catch (Throwable onAction) {
                try {
                    return resource.close().thenCompose(__ -> Promises.failure(onAction));
                }
                catch (Throwable onClose) {
                    onAction.addSuppressed(onClose);
                    return Promises.failure(onAction);
                }
            }
            try {
                return resource.close().thenApply(__ -> result);
            }
            catch (Throwable onClose) {
                return Promises.failure(onClose);
            }
        });
    }

    public static <T, R extends AutoCloseable> Promise<T> tryCompose(CompletionStage<R> stage, Function<? super R, ? extends CompletionStage<T>> fn) {
        return Promises.tryCompose(Promises.from(stage), fn);
    }

    public static <T, R extends AutoCloseable> Promise<T> tryCompose(Promise<R> p, Function<? super R, ? extends CompletionStage<T>> fn) {
        return p.thenCompose(resource -> {
            CompletionStage action;
            try {
                action = (CompletionStage)fn.apply((Object)resource);
            }
            catch (Throwable onAction) {
                try {
                    resource.close();
                    return Promises.failure(onAction);
                }
                catch (Exception onClose) {
                    onAction.addSuppressed(onClose);
                    return Promises.failure(onAction);
                }
            }
            CompletableFutureWrapper result = new CompletableFutureWrapper();
            action.whenComplete((actionResult, actionException) -> {
                try {
                    resource.close();
                    result.complete(actionResult, (Throwable)actionException);
                }
                catch (Throwable onClose) {
                    Promises.completeExceptionally(result, actionException, onClose);
                }
            });
            return result.onCancel(() -> SharedFunctions.cancelPromise(action, true));
        });
    }

    public static <T, R extends AsyncCloseable> Promise<T> tryComposeEx(CompletionStage<R> stage, Function<? super R, ? extends CompletionStage<T>> fn) {
        return Promises.tryComposeEx(Promises.from(stage), fn);
    }

    public static <T, R extends AsyncCloseable> Promise<T> tryComposeEx(Promise<R> p, Function<? super R, ? extends CompletionStage<T>> fn) {
        return p.thenCompose(resource -> {
            CompletionStage action;
            try {
                action = (CompletionStage)fn.apply((Object)resource);
            }
            catch (Throwable onAction) {
                try {
                    return resource.close().thenCompose(__ -> Promises.failure(onAction));
                }
                catch (Throwable onClose) {
                    onAction.addSuppressed(onClose);
                    return Promises.failure(onAction);
                }
            }
            CompletableFutureWrapper result = new CompletableFutureWrapper();
            action.whenComplete((actionResult, actionException) -> {
                try {
                    CompletionStage<Void> afterClose = resource.close();
                    afterClose.whenComplete((__, onClose) -> {
                        if (null == onClose) {
                            result.complete(actionResult, (Throwable)actionException);
                        } else {
                            Promises.completeExceptionally(result, actionException, onClose);
                        }
                    });
                }
                catch (Throwable onClose2) {
                    Promises.completeExceptionally(result, actionException, onClose2);
                }
            });
            return result.onCancel(() -> SharedFunctions.cancelPromise(action, true));
        });
    }

    public static <T, A, R> Promise<R> partitioned(Iterable<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream) {
        return Promises.partitioned1(values.iterator(), null, batchSize, spawner, downstream);
    }

    public static <T, A, R> Promise<R> partitioned(Iterable<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream, Executor downstreamExecutor) {
        return Promises.partitioned2(values.iterator(), null, batchSize, spawner, downstream, downstreamExecutor);
    }

    public static <T, A, R> Promise<R> partitioned(Stream<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream) {
        return Promises.partitioned1(values.iterator(), values, batchSize, spawner, downstream);
    }

    public static <T, A, R> Promise<R> partitioned(Stream<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream, Executor downstreamExecutor) {
        return Promises.partitioned2(values.iterator(), values, batchSize, spawner, downstream, downstreamExecutor);
    }

    private static <T, A, R> Promise<R> partitioned1(Iterator<? extends T> values, Object source, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream) {
        return Promises.parallelStep1(values, batchSize, spawner, downstream).dependent().thenApply(downstream.finisher().compose(IndexedStep::payload), true).as\u02b9(Promises.maybeClosingSource(null != source ? source : values)).unwrap();
    }

    private static <T, A, R> Promise<R> partitioned2(Iterator<? extends T> values, Object source, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream, Executor downstreamExecutor) {
        return Promises.parallelStep2(values, batchSize, spawner, downstream, downstreamExecutor).dependent().thenApplyAsync(downstream.finisher().compose(IndexedStep::payload), downstreamExecutor, true).as\u02b9(Promises.maybeClosingSource(null != source ? source : values)).unwrap();
    }

    private static <T, A, R> Promise<IndexedStep<A>> parallelStep1(Iterator<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream) {
        return Promises.loop(new IndexedStep(), step -> step.initial() || values.hasNext(), step -> {
            List valuesBatch = Promises.drainBatch(values, batchSize);
            if (valuesBatch.isEmpty()) {
                return Promises.success(step.initial() ? step.next(downstream.supplier().get()) : step);
            }
            List promisesBatch = valuesBatch.stream().map(spawner).collect(Collectors.toList());
            return Promises.all(promisesBatch).dependent().thenApply(vals -> step.next(Promises.accumulate(vals, step.initial(), step.payload(), downstream)), true);
        });
    }

    private static <T, A, R> Promise<IndexedStep<A>> parallelStep2(Iterator<? extends T> values, int batchSize, Function<? super T, CompletionStage<? extends T>> spawner, Collector<T, A, R> downstream, Executor downstreamExecutor) {
        return Promises.loop(new IndexedStep(), step -> step.initial() || values.hasNext(), step -> {
            List valuesBatch = Promises.drainBatch(values, batchSize);
            if (valuesBatch.isEmpty()) {
                return step.initial() ? CompletableTask.supplyAsync(() -> step.next(downstream.supplier().get()), downstreamExecutor) : Promises.success(step);
            }
            List promisesBatch = valuesBatch.stream().map(spawner).collect(Collectors.toList());
            return Promises.all(promisesBatch).dependent().thenApplyAsync(vals -> step.next(Promises.accumulate(vals, step.initial(), step.payload(), downstream)), downstreamExecutor, true);
        });
    }

    private static <T> List<T> drainBatch(Iterator<? extends T> values, int batchSize) {
        ArrayList<T> valuesBatch = new ArrayList<T>(batchSize);
        for (int count = 0; values.hasNext() && count < batchSize; ++count) {
            valuesBatch.add(values.next());
        }
        return valuesBatch;
    }

    private static <T, A, R> A accumulate(List<T> vals, boolean initial, A current, Collector<T, A, R> downstream) {
        Object insertion = downstream.supplier().get();
        vals.stream().forEach(v -> downstream.accumulator().accept(insertion, v));
        return (A)(initial ? insertion : downstream.combiner().apply(current, insertion));
    }

    private static <T> Function<DependentPromise<T>, DependentPromise<T>> maybeClosingSource(Object source) {
        if (source instanceof AutoCloseable) {
            return p -> p.whenComplete((r, e) -> {
                try {
                    ((AutoCloseable)source).close();
                }
                catch (Exception ex) {
                    if (null != e) {
                        e.addSuppressed(ex);
                    }
                    throw SharedFunctions.wrapCompletionException(ex);
                }
            }, true);
        }
        return Function.identity();
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(CompletionStage<? extends T> ... promises) {
        return Promises.all(Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> all(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.all(true, promises);
    }

    public static <K, T> Promise<Map<K, T>> all(Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.all(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.all(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> all(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(null != promises ? promises.size() : 0, 0, cancelRemaining, promises);
    }

    public static <K, T> Promise<Map<K, T>> all(boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(null == promises ? 0 : promises.size(), 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> any(CompletionStage<? extends T> ... promises) {
        return Promises.any(Arrays.asList(promises));
    }

    public static <T> Promise<T> any(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.any(true, promises);
    }

    public static <K, T> Promise<Map<K, T>> any(Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.any(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> any(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.any(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<T> any(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        int size = null == promises ? 0 : promises.size();
        switch (size) {
            case 0: {
                return Promises.insufficientNumberOfArguments(1, 0);
            }
            case 1: {
                CompletionStage<? extends T> singleResult = promises.get(0);
                return Promises.transform(singleResult, Function.identity(), Promises::wrapMultitargetException);
            }
        }
        return Promises.transform(Promises.atLeast(1, size - 1, cancelRemaining, promises), Promises::firstElement, Function.identity());
    }

    public static <K, T> Promise<Map<K, T>> any(boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(1, Promises.maxAllowedErrors(promises, 1), cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> anyStrict(CompletionStage<? extends T> ... promises) {
        return Promises.anyStrict(Arrays.asList(promises));
    }

    public static <T> Promise<T> anyStrict(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.anyStrict(true, promises);
    }

    public static <K, T> Promise<Map<K, T>> anyStrict(Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.anyStrict(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> anyStrict(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.anyStrict(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<T> anyStrict(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        int size = null == promises ? 0 : promises.size();
        switch (size) {
            case 0: {
                return Promises.insufficientNumberOfArguments(1, 0);
            }
            case 1: {
                CompletionStage<? extends T> singleResult = promises.get(0);
                return Promises.from(singleResult);
            }
        }
        return Promises.transform(Promises.atLeast(1, 0, cancelRemaining, promises), Promises::firstElement, Promises::unwrapMultitargetException);
    }

    public static <K, T> Promise<Map<K, T>> anyStrict(boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(1, 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastOrdered(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastOrdered(minResultsCount, true, promises);
    }

    public static <K, T> Promise<Map<K, T>> atLeast(int minResultsCount, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, Promises.maxAllowedErrors(promises, minResultsCount), cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastOrdered(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastOrdered(minResultsCount, Promises.maxAllowedErrors(promises, minResultsCount), cancelRemaining, promises);
    }

    public static <K, T> Promise<Map<K, T>> atLeast(int minResultsCount, boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, Promises.maxAllowedErrors(promises, minResultsCount), cancelRemaining, promises);
    }

    private static int maxAllowedErrors(Map<?, ?> promises, int minResultsCount) {
        return null == promises ? 0 : Promises.maxAllowedErrors(promises.entrySet(), minResultsCount);
    }

    private static int maxAllowedErrors(Collection<?> promises, int minResultsCount) {
        return null == promises ? 0 : Math.max(0, promises.size() - minResultsCount);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastStrict(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastStrict(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<Optional<T>>> atLeastOrderedStrict(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastOrderedStrict(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<Optional<T>>> atLeastOrderedStrict(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastOrderedStrict(minResultsCount, true, promises);
    }

    public static <K, T> Promise<Map<K, T>> atLeastStrict(int minResultsCount, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastStrict(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<Optional<T>>> atLeastOrderedStrict(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastOrderedStrict(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<Optional<T>>> atLeastOrderedStrict(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastOrdered(minResultsCount, 0, cancelRemaining, promises);
    }

    public static <K, T> Promise<Map<K, T>> atLeastStrict(int minResultsCount, boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, maxErrorsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, maxErrorsCount, cancelRemaining, AggregatingPromise.newWithSuccessResults(), Collections::singletonList, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastOrdered(minResultsCount, maxErrorsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<Optional<T>>> atLeastOrdered(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, maxErrorsCount, cancelRemaining, AggregatingPromise.newWithAllResults(), (? super T v) -> Collections.singletonList(Optional.ofNullable(v)), promises);
    }

    private static <T, R> Promise<List<R>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, AggregatingPromise.Constructor<T, R> ctr, Function<? super T, ? extends List<R>> singleResultMapper, List<? extends CompletionStage<? extends T>> promises) {
        int size;
        int n = size = null == promises ? 0 : promises.size();
        if (minResultsCount > size) {
            Promise<List<R>> result = Promises.insufficientNumberOfArguments(minResultsCount, size);
            if (cancelRemaining && size > 0) {
                promises.stream().forEach(p -> SharedFunctions.cancelPromise(p, true));
            }
            return result;
        }
        if (minResultsCount == 0) {
            return Promises.success(Collections.emptyList());
        }
        if (size == 1) {
            CompletionStage<? extends T> stage = promises.get(0);
            return Promises.transform(stage, singleResultMapper, Promises::wrapMultitargetException);
        }
        return ctr.create(minResultsCount, maxErrorsCount, cancelRemaining, promises).start();
    }

    public static <K, T> Promise<Map<K, T>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        return Promises.atLeast(minResultsCount, maxErrorsCount, cancelRemaining, AggregatingPromise.newWithEmptyResults(), SharedFunctions.nullify(), Promises.collectKeyedResults(result, promises)).dependent().thenApply(__ -> Collections.unmodifiableMap(Promises.limitEntries(result, minResultsCount)), true).unwrap();
    }

    public static Promise<Void> retry(Runnable codeBlock, Executor executor, RetryPolicy<? super Void> retryPolicy) {
        return Promises.retry(RetryRunnable.from(codeBlock), executor, retryPolicy);
    }

    public static Promise<Void> retry(RetryRunnable codeBlock, Executor executor, RetryPolicy<? super Void> retryPolicy) {
        return Promises.retry(RetryCallable.from(codeBlock), executor, retryPolicy.acceptNullResult());
    }

    public static <T> Promise<T> retry(Callable<T> codeBlock, Executor executor, RetryPolicy<? super T> retryPolicy) {
        return Promises.retry(RetryCallable.from(codeBlock), executor, retryPolicy);
    }

    public static <T extends C, C> Promise<T> retry(RetryCallable<T, C> codeBlock, Executor executor, RetryPolicy<? super C> retryPolicy) {
        return Promises.retryFuture((RetryContext<C> ctx) -> CompletableTask.submit(() -> codeBlock.call(ctx), executor), retryPolicy);
    }

    public static <T> Promise<T> retryOptional(Callable<Optional<T>> codeBlock, Executor executor, RetryPolicy<? super T> retryPolicy) {
        return Promises.retryOptional(RetryCallable.from(codeBlock), executor, retryPolicy);
    }

    public static <T extends C, C> Promise<T> retryOptional(RetryCallable<Optional<T>, C> codeBlock, Executor executor, RetryPolicy<? super C> retryPolicy) {
        return Promises.retry((RetryContext<C> ctx) -> ((Optional)codeBlock.call(ctx)).orElse(null), executor, retryPolicy);
    }

    public static <T> Promise<T> retryFuture(Callable<? extends CompletionStage<T>> invoker, RetryPolicy<? super T> retryPolicy) {
        return Promises.retryFuture(RetryCallable.from(invoker), retryPolicy);
    }

    public static <T extends C, C> Promise<T> retryFuture(RetryCallable<? extends CompletionStage<T>, C> futureFactory, RetryPolicy<? super C> retryPolicy) {
        return Promises.retryImpl(ctx -> {
            try {
                return Promises.from((CompletionStage)futureFactory.call((RetryContext)ctx));
            }
            catch (Throwable ex) {
                return Promises.failure(ex);
            }
        }, retryPolicy, true);
    }

    private static <T extends C, C> Promise<T> retryImpl(Function<? super RetryContext<C>, ? extends Promise<T>> futureFactory, RetryPolicy<? super C> retryPolicy, boolean usePrevAsync) {
        /*
         * Exception performing whole class analysis ignored.
         */
        class State {
            private final boolean isDone;
            private final DependentPromise<?> prevAsync;
            final RetryContext<C> ctx;
            final RetryPolicy.Verdict verdict;
            final /* synthetic */ RetryPolicy val$retryPolicy;

            private State(RetryContext<C> ctx, DependentPromise<?> prevAsync, boolean isDone) {
                this.val$retryPolicy = var4_4;
                this.ctx = ctx;
                this.prevAsync = prevAsync;
                this.isDone = isDone;
                this.verdict = isDone ? null : this.val$retryPolicy.shouldContinue(ctx);
            }

            State(RetryContext<C> retryContext) {
                this(ctx, null, false, (RetryPolicy)((Object)retryContext));
            }

            State next(Throwable error, Duration d, DependentPromise<?> prevAsync) {
                return new State(this.ctx.nextRetry(d, Promises.unwrapCompletionException(error)), this.useAsync(prevAsync), false, this.val$retryPolicy);
            }

            State next(T result, Duration d, DependentPromise<?> prevAsync) {
                return new State(this.ctx.nextRetry(d, result), this.useAsync(prevAsync), false, this.val$retryPolicy);
            }

            State done(T result, Duration d) {
                return new State(this.ctx.nextRetry(d, result), null, true, this.val$retryPolicy);
            }

            boolean isRunning() {
                return !this.isDone && this.verdict.shouldExecute();
            }

            Promise<T> toPromise() {
                return this.isDone ? Promises.success(this.ctx.getLastResult()) : Promises.failure(this.ctx.asFailure());
            }

            private DependentPromise<?> useAsync(DependentPromise<?> prevAsync) {
                return prevAsync != null ? prevAsync : this.prevAsync;
            }

            DependentPromise<?> makeDelay(Duration delay) {
                return this.prevAsync == null ? Timeouts.delay(delay).dependent() : this.prevAsync.exceptionally(SharedFunctions.nullify()).delay(delay, true, true);
            }
        }
        return Promises.loop(new State(RetryContext.initial(), retryPolicy), State::isRunning, currentState -> {
            RetryContext ctx = currentState.ctx;
            RetryPolicy.Verdict verdict = currentState.verdict;
            Supplier<Promise> callSupplier = () -> {
                long startTime = System.nanoTime();
                DependentPromise<Object> target = ((Promise)futureFactory.apply(ctx)).dependent();
                Duration timeout = verdict.timeout();
                DependentPromise<Object> withTimeout = DelayPolicy.isValid(timeout) ? target.orTimeout(timeout, true, true) : target;
                return withTimeout.handle((value, ex) -> {
                    Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
                    if (null == ex) {
                        if (retryPolicy.acceptResult((Object)value)) {
                            return currentState.done(value, duration);
                        }
                        return currentState.next(value, duration, target);
                    }
                    return currentState.next(ex, duration, (DependentPromise<?>)target);
                }, true);
            };
            Duration backoffDelay = verdict.backoffDelay();
            return DelayPolicy.isValid(backoffDelay) ? currentState.makeDelay(backoffDelay).thenCompose(__ -> (CompletionStage)callSupplier.get(), true).exceptionally(ex -> currentState.next(ex, Duration.ZERO, null), true) : (DependentPromise<State>)callSupplier.get();
        }).dependent().thenCompose(State::toPromise, true).unwrap();
    }

    private static <T, U> Promise<T> transform(CompletionStage<U> original, Function<? super U, ? extends T> resultMapper, Function<? super Throwable, ? extends Throwable> errorMapper) {
        CompletableFutureWrapper result = new CompletableFutureWrapper();
        original.whenComplete((r, e) -> SharedFunctions.iif(null == e ? result.success(resultMapper.apply((Object)r)) : result.failure((Throwable)errorMapper.apply((Throwable)e))));
        return result.onCancel(() -> SharedFunctions.cancelPromise(original, true));
    }

    private static <T> T firstElement(Collection<? extends T> collection) {
        return collection.stream().findFirst().get();
    }

    private static <E extends Throwable> Throwable unwrapMultitargetException(E exception) {
        Throwable targetException = Promises.unwrapCompletionException(exception);
        if (targetException instanceof MultitargetException) {
            return ((MultitargetException)targetException).getFirstException().get();
        }
        return targetException;
    }

    private static <E extends Throwable> MultitargetException wrapMultitargetException(E exception) {
        if (exception instanceof MultitargetException) {
            return (MultitargetException)exception;
        }
        return new MultitargetException("Aggregated promise was completed exceptionally (1 out of 1)", Collections.singletonList(exception));
    }

    private static <T> Promise<T> insufficientNumberOfArguments(int minResultCount, int size) {
        String message = String.format("The number of futures supplied (%d) is less than a number of futures to await (%d)", size, minResultCount);
        NoSuchElementException ex = new NoSuchElementException(message);
        ex.fillInStackTrace();
        return Promises.failure(ex);
    }

    private static <T> void completeExceptionally(CompletableFutureWrapper<T> result, Throwable actionException, Throwable onClose) {
        if (null != actionException) {
            actionException.addSuppressed(onClose);
            result.failure(actionException);
        } else {
            result.failure(onClose);
        }
    }

    private static <K, T> List<? extends CompletionStage<? extends T>> collectKeyedResults(Map<K, T> result, Map<? extends K, ? extends CompletionStage<? extends T>> promises) {
        if (null == promises || promises.isEmpty()) {
            return Collections.emptyList();
        }
        return promises.entrySet().stream().map(e -> Promises.from((CompletionStage)e.getValue()).dependent().thenApply(value -> {
            result.put(e.getKey(), value);
            return value;
        }, true)).collect(Collectors.toList());
    }

    private static <K, V> Map<K, V> limitEntries(Map<K, V> map, int maxCount) {
        HashMap<K, V> result = new HashMap<K, V>(map);
        if (result.size() <= maxCount) {
            return result;
        }
        return result.entrySet().stream().limit(maxCount).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class IndexedStep<T> {
        private final int idx;
        private final T payload;

        IndexedStep() {
            this(0, null);
        }

        private IndexedStep(int idx, T payload) {
            this.idx = idx;
            this.payload = payload;
        }

        IndexedStep<T> next(T payload) {
            return new IndexedStep<T>(this.idx + 1, payload);
        }

        boolean initial() {
            return this.idx == 0;
        }

        T payload() {
            return this.payload;
        }
    }
}

