/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.Callable;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.RetryRunnable;

@FunctionalInterface
public interface RetryCallable<V, T> {
    public V call(RetryContext<T> var1) throws Exception;

    public static <V, T> RetryCallable<V, T> from(Callable<? extends V> callable) {
        return ctx -> callable.call();
    }

    public static RetryCallable<Void, Void> from(RetryRunnable runnable) {
        return ctx -> {
            runnable.run(ctx);
            return null;
        };
    }

    public static RetryCallable<Void, Void> from(Runnable runnable) {
        return RetryCallable.from(RetryRunnable.from(runnable));
    }
}

