/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import net.tascalate.concurrent.RetryException;

public final class RetryContext<T> {
    private final int retryCount;
    private final Duration lastCallDuration;
    private final T lastResult;
    private final Throwable lastError;

    private RetryContext(int retryCount, Duration lastCallDuration, T lastResult, Throwable lastError) {
        this.retryCount = retryCount;
        this.lastCallDuration = lastCallDuration;
        this.lastResult = lastResult;
        this.lastError = lastError;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public Duration getLastCallDuration() {
        return this.lastCallDuration;
    }

    public T getLastResult() {
        return this.lastResult;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public RetryContext<T> overrideRetryCount(int newRetryCount) {
        return new RetryContext<T>(newRetryCount, this.lastCallDuration, this.lastResult, this.lastError);
    }

    public RetryContext<T> overrideLastCallDuration(Duration newDuration) {
        return new RetryContext<T>(this.retryCount, newDuration, this.lastResult, this.lastError);
    }

    public RetryContext<T> overrideLastResult(T newResult) {
        return new RetryContext<T>(this.retryCount, this.lastCallDuration, newResult, this.lastError);
    }

    public RetryContext<T> overrideLastError(Throwable newError) {
        return new RetryContext<T>(this.retryCount, this.lastCallDuration, this.lastResult, newError);
    }

    static <T> RetryContext<T> initial() {
        return new RetryContext<Object>(0, Duration.ZERO, null, null);
    }

    RetryContext<T> nextRetry(Duration callDuration, T lastResult) {
        return new RetryContext<T>(this.retryCount + 1, callDuration, lastResult, null);
    }

    RetryContext<T> nextRetry(Duration callDuration, Throwable lastError) {
        return new RetryContext<Object>(this.retryCount + 1, callDuration, null, lastError);
    }

    RetryException asFailure() {
        RetryException result = new RetryException(this.retryCount, this.lastCallDuration, this.lastError);
        result.fillInStackTrace();
        return result;
    }
}

