/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.Timeouts;

public class RetryPolicy<T> {
    protected static final Verdict DONT_RETRY = new Verdict(){

        @Override
        public boolean shouldExecute() {
            return false;
        }

        @Override
        public Duration backoffDelay() {
            return Timeouts.NEGATIVE_DURATION;
        }

        @Override
        public Duration timeout() {
            return Timeouts.NEGATIVE_DURATION;
        }
    };
    private static final Predicate<RetryContext<Object>> PREDICATE_FALSE = ctx -> false;
    public static final Predicate<Object> ACCEPT_NULL_RESULT = v -> true;
    public static final Predicate<Object> REJECT_NULL_RESULT = v -> v != null;
    public static final Predicate<Object> IGNORE_RESULT = v -> false;
    public static final RetryPolicy<Object> DEFAULT = new RetryPolicy().retryOn(Exception.class);
    private final int maxRetries;
    private final Predicate<? super T> resultValidator;
    private final Set<Class<? extends Throwable>> retryOn;
    private final Set<Class<? extends Throwable>> abortOn;
    private final Predicate<RetryContext<? extends T>> retryPredicate;
    private final Predicate<RetryContext<? extends T>> abortPredicate;
    private final DelayPolicy<? super T> backoff;
    private final DelayPolicy<? super T> timeout;

    @SafeVarargs
    public final RetryPolicy<T> retryOn(Class<? extends Throwable> ... retryOnThrowables) {
        return this.retryOn(Arrays.asList(retryOnThrowables));
    }

    public RetryPolicy<T> retryOn(Collection<Class<? extends Throwable>> retryOnThrowables) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, RetryPolicy.setPlusElems(this.retryOn, retryOnThrowables), this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    @SafeVarargs
    public final RetryPolicy<T> abortOn(Class<? extends Throwable> ... abortOnThrowables) {
        return this.abortOn(Arrays.asList(abortOnThrowables));
    }

    public RetryPolicy<T> abortOn(Collection<Class<? extends Throwable>> abortOnThrowables) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, RetryPolicy.setPlusElems(this.abortOn, abortOnThrowables), this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> abortIf(Predicate<RetryContext<? extends T>> abortPredicate) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate.or(abortPredicate), this.backoff, this.timeout);
    }

    public RetryPolicy<T> retryIf(Predicate<RetryContext<? extends T>> retryPredicate) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate.or(retryPredicate), this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> withoutAbortRules() {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, Collections.emptySet(), this.retryPredicate, RetryPolicy.predicateFalse(), this.backoff, this.timeout);
    }

    public RetryPolicy<T> withoutRetryRules() {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, Collections.emptySet(), this.abortOn, RetryPolicy.predicateFalse(), this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> retryOnce() {
        return new RetryPolicy<T>(0, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> retryInfinitely() {
        return new RetryPolicy<T>(-1, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> withMaxRetries(int maxRetries) {
        return new RetryPolicy<T>(maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> acceptNullResult() {
        return new RetryPolicy<T>(this.maxRetries, ACCEPT_NULL_RESULT, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> rejectNullResult() {
        return new RetryPolicy<T>(this.maxRetries, REJECT_NULL_RESULT, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> withResultValidator(Predicate<? super T> resultValidator) {
        return new RetryPolicy<T>(this.maxRetries, resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy<T> withBackoff(DelayPolicy<? super T> backoff) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, backoff, this.timeout);
    }

    public RetryPolicy<T> withoutBackoff() {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, DelayPolicy.INVALID, this.timeout);
    }

    public RetryPolicy<T> withTimeout(DelayPolicy<? super T> timeout) {
        return new RetryPolicy<T>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, timeout);
    }

    public RetryPolicy<T> withoutTimeout() {
        return new RetryPolicy<Object>(this.maxRetries, this.resultValidator, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, DelayPolicy.INVALID);
    }

    public RetryPolicy(int maxRetries, Predicate<? super T> resultValidator, Set<Class<? extends Throwable>> retryOn, Set<Class<? extends Throwable>> abortOn, Predicate<RetryContext<? extends T>> retryPredicate, Predicate<RetryContext<? extends T>> abortPredicate, DelayPolicy<? super T> backoff, DelayPolicy<? super T> timeout) {
        this.maxRetries = maxRetries;
        this.resultValidator = resultValidator;
        this.retryOn = retryOn;
        this.abortOn = abortOn;
        this.retryPredicate = retryPredicate;
        this.abortPredicate = abortPredicate;
        this.backoff = backoff;
        this.timeout = timeout;
    }

    public RetryPolicy() {
        this(-1, DelayPolicy.DEFAULT);
    }

    public RetryPolicy(long backoff) {
        this(-1, backoff);
    }

    public RetryPolicy(Predicate<? super T> resultValidator) {
        this(-1, resultValidator, DelayPolicy.DEFAULT);
    }

    public RetryPolicy(Predicate<? super T> resultValidator, long backoff) {
        this(-1, resultValidator, backoff);
    }

    public RetryPolicy(int maxRetries, long backoff) {
        this(maxRetries, DelayPolicy.fixedInterval(backoff).withFirstRetryNoDelay());
    }

    public RetryPolicy(int maxRetries, Predicate<? super T> resultValidator, long backoff) {
        this(maxRetries, resultValidator, DelayPolicy.fixedInterval(backoff).withFirstRetryNoDelay());
    }

    public RetryPolicy(int maxRetries, long backoff, long timeout) {
        this(maxRetries, ACCEPT_NULL_RESULT, backoff, timeout);
    }

    public RetryPolicy(int maxRetries, Predicate<? super T> resultValidator, long backoff, long timeout) {
        this(maxRetries, resultValidator, DelayPolicy.fixedInterval(backoff).withFirstRetryNoDelay(), DelayPolicy.fixedInterval(timeout));
    }

    public RetryPolicy(int maxRetries, DelayPolicy<? super T> backoff) {
        this(maxRetries, backoff, DelayPolicy.INVALID);
    }

    public RetryPolicy(int maxRetries, Predicate<? super T> resultValidator, DelayPolicy<? super T> backoff) {
        this(maxRetries, resultValidator, backoff, DelayPolicy.INVALID);
    }

    public RetryPolicy(int maxRetries, DelayPolicy<? super T> backoff, DelayPolicy<? super T> timeout) {
        this(maxRetries, ACCEPT_NULL_RESULT, backoff, timeout);
    }

    public RetryPolicy(int maxRetries, Predicate<? super T> resultValidator, DelayPolicy<? super T> backoff, DelayPolicy<? super T> timeout) {
        this(maxRetries, resultValidator, Collections.emptySet(), Collections.emptySet(), RetryPolicy.predicateFalse(), RetryPolicy.predicateFalse(), backoff, timeout);
    }

    protected boolean acceptResult(T result) {
        return this.resultValidator.test(result);
    }

    protected Verdict shouldContinue(RetryContext<? extends T> context) {
        boolean result = this.tooManyRetries(context) ? false : (this.abortPredicate.test(context) ? false : (this.retryPredicate.test(context) ? true : this.exceptionClassRetryable(context)));
        return result ? new PositiveVerdict(this.backoff.delay(context), this.timeout.delay(context)) : DONT_RETRY;
    }

    protected boolean exceptionClassRetryable(RetryContext<?> context) {
        if (context.getLastError() == null) {
            return true;
        }
        Class<?> e = context.getLastError().getClass();
        return !RetryPolicy.matches(e, this.abortOn) && RetryPolicy.matches(e, this.retryOn);
    }

    private boolean tooManyRetries(RetryContext<?> context) {
        return this.maxRetries >= 0 && context.getRetryCount() > this.maxRetries;
    }

    private static boolean matches(Class<? extends Throwable> throwable, Set<Class<? extends Throwable>> set) {
        return set.stream().anyMatch(c -> c.isAssignableFrom(throwable));
    }

    private static <T> Set<T> setPlusElems(Set<T> initial, Collection<T> newElement) {
        HashSet<T> copy = new HashSet<T>(initial);
        copy.addAll(newElement);
        return Collections.unmodifiableSet(copy);
    }

    private static <T> Predicate<RetryContext<? extends T>> predicateFalse() {
        return PREDICATE_FALSE;
    }

    protected static final class PositiveVerdict
    implements Verdict {
        private final Duration backoffDelay;
        private final Duration timeoutDelay;

        PositiveVerdict(Duration backoffDelay, Duration timeoutDelay) {
            this.backoffDelay = backoffDelay;
            this.timeoutDelay = timeoutDelay;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }

        @Override
        public Duration backoffDelay() {
            return this.backoffDelay;
        }

        @Override
        public Duration timeout() {
            return this.timeoutDelay;
        }
    }

    public static interface Verdict {
        public boolean shouldExecute();

        public Duration backoffDelay();

        public Duration timeout();
    }
}

