/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.core.CancelMethodsCache;

class SharedFunctions {
    static final Function<Object, Throwable> NO_SUCH_ELEMENT = t -> new NoSuchElementException("Result rejected by filter: " + t);
    private static final BiFunction<Object, Object, Object> SELECT_FIRST = (u, v) -> u;
    private static final BiFunction<Object, Object, Object> SELECT_SECOND = (u, v) -> v;
    private static final Function<Object, Object> NULLIFY = v -> null;

    private SharedFunctions() {
    }

    static Throwable unwrapCompletionException(Throwable ex) {
        Throwable nested = ex;
        while (nested instanceof CompletionException) {
            nested = nested.getCause();
        }
        return null == nested ? ex : nested;
    }

    static CompletionException wrapCompletionException(Throwable e) {
        if (e instanceof CompletionException) {
            return (CompletionException)e;
        }
        return new CompletionException(e);
    }

    static Throwable unwrapExecutionException(Throwable ex) {
        Throwable nested = ex;
        while (nested instanceof ExecutionException) {
            nested = nested.getCause();
        }
        return null == nested ? ex : nested;
    }

    static ExecutionException wrapExecutionException(Throwable e) {
        if (e instanceof ExecutionException) {
            return (ExecutionException)e;
        }
        return new ExecutionException(e);
    }

    static <T> CompletionStage<T> failure(Function<? super T, Throwable> errorSupplier, T value) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(errorSupplier.apply(value));
        return result;
    }

    static boolean cancelPromise(CompletionStage<?> promise, boolean mayInterruptIfRunning) {
        if (promise instanceof Future) {
            Future future = (Future)((Object)promise);
            return future.cancel(mayInterruptIfRunning);
        }
        return CancelMethodsCache.cancellationOf(promise.getClass()).apply(promise, mayInterruptIfRunning);
    }

    static <T, U> Function<T, U> applyAndCancel(Function<T, U> fn, boolean cancel, Promise<?> target) {
        if (cancel) {
            return fn.andThen(u -> {
                target.cancel(true);
                return u;
            });
        }
        return fn;
    }

    static <U, V> BiFunction<U, V, U> selectFirst() {
        return SELECT_FIRST;
    }

    static <U, V> BiFunction<U, V, V> selectSecond() {
        return SELECT_SECOND;
    }

    static <T, R> Function<T, R> nullify() {
        return NULLIFY;
    }

    static <T> Supplier<T> supply(T value) {
        return () -> value;
    }

    static void iif(boolean v) {
    }
}

