/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.TaskCompletionService;
import net.tascalate.concurrent.TaskExecutorService;
import net.tascalate.concurrent.TaskExecutors;

public class TaskExecutorCompletionService<V>
extends ExecutorCompletionService<V>
implements TaskCompletionService<V> {
    public TaskExecutorCompletionService(TaskExecutorService executor) {
        super(TaskExecutorCompletionService.wrapExecutor(executor));
    }

    public TaskExecutorCompletionService(TaskExecutorService executor, BlockingQueue<Promise<V>> completionQueue) {
        super(TaskExecutorCompletionService.wrapExecutor(executor), TaskExecutorCompletionService.cast(completionQueue));
    }

    @Override
    public Promise<V> submit(Callable<V> task) {
        return (Promise)super.submit(task);
    }

    @Override
    public Promise<V> submit(Runnable task, V result) {
        return (Promise)super.submit(task, result);
    }

    @Override
    public Promise<V> take() throws InterruptedException {
        return (Promise)super.take();
    }

    @Override
    public Promise<V> poll() {
        return (Promise)super.poll();
    }

    @Override
    public Promise<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Promise)super.poll(timeout, unit);
    }

    private static <V> BlockingQueue<Future<V>> cast(BlockingQueue<? extends Future<V>> queue) {
        return queue;
    }

    private static Executor wrapExecutor(final Executor executor) {
        if (executor instanceof TaskExecutorService && executor instanceof AbstractExecutorService) {
            return executor;
        }
        return new AbstractExecutorService(){
            private volatile boolean terminated;

            @Override
            public void execute(Runnable command) {
                executor.execute(command);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return this.newTaskFor(Executors.callable(runnable, value));
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return TaskExecutors.newRunnablePromise(this, callable);
            }

            @Override
            public void shutdown() {
                this.terminated = true;
            }

            @Override
            public List<Runnable> shutdownNow() {
                this.terminated = true;
                return Collections.emptyList();
            }

            @Override
            public boolean isShutdown() {
                return this.terminated;
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return true;
            }
        };
    }
}

